/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.jaxrs.io.operations.ExecutionRequest;
import org.nuxeo.ecm.automation.server.jaxrs.ResponseHelper;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestCleanupHandler;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestContext;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="batch")
public class BatchResource
extends AbstractResource<ResourceTypeImpl> {
    private static final String REQUEST_BATCH_ID = "batchId";
    private static final String REQUEST_FILE_IDX = "fileIdx";
    protected static final Log log = LogFactory.getLog(BatchResource.class);

    public CoreSession getCoreSession(HttpServletRequest request) {
        return SessionFactory.getSession((HttpServletRequest)request);
    }

    protected Response buildFromString(String message) {
        return Response.ok((Object)message, (String)"application/json").header("Content-Length", (Object)message.length()).build();
    }

    protected Response buildHtmlFromString(String message) {
        message = "<html>" + message + "</html>";
        return Response.ok((Object)message, (MediaType)MediaType.TEXT_HTML_TYPE).header("Content-Length", (Object)message.length()).build();
    }

    protected Response buildFromMap(Map<String, String> map) throws IOException {
        return this.buildFromMap(map, false);
    }

    protected Response buildFromMap(Map<String, String> map, boolean html) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayOutputStream out = new ByteArrayOutputStream(128);
        mapper.writeValue((OutputStream)out, map);
        String result = out.toString("UTF-8");
        if (html) {
            return this.buildHtmlFromString(result);
        }
        return this.buildFromString(result);
    }

    @Deprecated
    protected int getUploadWaitTimeout() {
        String t = Framework.getProperty((String)"org.nuxeo.batch.upload.wait.timeout", (String)"5");
        return Integer.parseInt(t);
    }

    @POST
    @Path(value="/upload")
    public Object doPost(@Context HttpServletRequest request) throws IOException {
        boolean useIFrame = false;
        String fileName = request.getHeader("X-File-Name");
        String fileSize = request.getHeader("X-File-Size");
        String batchId = request.getHeader("X-Batch-Id");
        String mimeType = request.getHeader("X-File-Type");
        String idx = request.getHeader("X-File-Idx");
        Object is = null;
        String contentType = request.getHeader("Content-Type");
        if (contentType != null && contentType.contains("multipart")) {
            Blob blob;
            useIFrame = true;
            FormData formData = new FormData(request);
            if (formData.getString(REQUEST_BATCH_ID) != null) {
                batchId = formData.getString(REQUEST_BATCH_ID);
            }
            if (formData.getString(REQUEST_FILE_IDX) != null) {
                idx = formData.getString(REQUEST_FILE_IDX);
            }
            if (idx == null || "".equals(idx.trim())) {
                idx = "0";
            }
            if ((blob = formData.getFirstBlob()) != null) {
                is = blob.getStream();
                fileName = blob.getFilename();
                mimeType = blob.getMimeType();
            }
        } else {
            fileName = URLDecoder.decode(fileName, "UTF-8");
            is = request.getInputStream();
        }
        log.debug((Object)("uploaded " + fileName + " (" + fileSize + "b)"));
        BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
        bm.addStream(batchId, idx, (InputStream)is, fileName, mimeType);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(REQUEST_BATCH_ID, batchId);
        result.put("uploaded", "true");
        return this.buildFromMap(result, useIFrame);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/execute")
    public Object exec(@Context HttpServletRequest request, ExecutionRequest xreq) {
        Map params = xreq.getParams();
        String batchId = (String)params.get(REQUEST_BATCH_ID);
        String fileIdx = (String)params.get(REQUEST_FILE_IDX);
        String operationId = (String)params.get("operationId");
        params.remove(REQUEST_BATCH_ID);
        params.remove("operationId");
        final BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
        request.setAttribute(REQUEST_BATCH_ID, (Object)batchId);
        RequestContext.getActiveContext((ServletRequest)request).addRequestCleanupHandler(new RequestCleanupHandler(){

            public void cleanup(HttpServletRequest req) {
                String bid = (String)req.getAttribute(BatchResource.REQUEST_BATCH_ID);
                bm.clean(bid);
            }
        });
        try {
            OperationContext ctx = xreq.createContext(request, this.getCoreSession(request));
            Object result = StringUtils.isEmpty((String)fileIdx) ? bm.execute(batchId, operationId, this.getCoreSession(request), (Map<String, Object>)ctx, params) : bm.execute(batchId, fileIdx, operationId, this.getCoreSession(request), (Map<String, Object>)ctx, params);
            return ResponseHelper.getResponse(result, request);
        }
        catch (IOException | MessagingException | ClientException e) {
            log.error((Object)"Error while executing automation batch ", e);
            if (WebException.isSecurityError((Throwable)e)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"error\" : \"" + e.getMessage() + "\"}")).build();
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\" : \"" + e.getMessage() + "\"}")).build();
        }
    }

    @GET
    @Path(value="/files/{batchId}")
    public Object getFilesBatch(@PathParam(value="batchId") String batchId) throws IOException {
        BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
        List<Blob> blobs = bm.getBlobs(batchId);
        ArrayList result = new ArrayList();
        for (Blob blob : blobs) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", blob.getFilename());
            map.put("size", blob.getLength());
            result.add(map);
        }
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayOutputStream out = new ByteArrayOutputStream(128);
        mapper.writeValue((OutputStream)out, result);
        return this.buildFromString(out.toString("UTF-8"));
    }

    @GET
    @Path(value="/drop/{batchId}")
    public Object dropBatch(@PathParam(value="batchId") String batchId) throws IOException {
        BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
        bm.clean(batchId);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(REQUEST_BATCH_ID, batchId);
        result.put("dropped", "true");
        return this.buildFromMap(result);
    }
}

