/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.webengine.fm.extensions;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.nuxeo.theme.webengine.fm.extensions.Utils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NXThemesTabsDirective
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (loopVars.length != 0) {
            throw new TemplateModelException("This directive doesn't allow loop variables.");
        }
        if (body == null) {
            throw new TemplateModelException("Expected a body");
        }
        Map<String, String> attributes = Utils.getTemplateDirectiveParameters(params);
        String identifier = attributes.get("identifier");
        String styleClass = attributes.get("styleClass");
        String controlledBy = attributes.get("controlledBy");
        HashMap<String, Object> view = new HashMap<String, Object>();
        view.put("id", identifier);
        HashMap<String, Object> widget = new HashMap<String, Object>();
        widget.put("type", "tabs");
        if (styleClass != null) {
            widget.put("styleClass", styleClass);
        }
        if (null != controlledBy) {
            view.put("controllers", controlledBy.split(","));
        }
        StringWriter sw = new StringWriter();
        body.render((Writer)sw);
        String content = String.format("<tabs>%s</tabs>", sw.getBuffer().toString());
        ArrayList items = new ArrayList();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            Document doc = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(content.getBytes()));
            NodeList itemList = doc.getElementsByTagName("tab");
            for (int i = 0; i < itemList.getLength(); ++i) {
                Node itemNode = itemList.item(i);
                NamedNodeMap attrs = itemNode.getAttributes();
                Node link = attrs.getNamedItem("link");
                Node label = attrs.getNamedItem("label");
                Node switchTo = attrs.getNamedItem("switchTo");
                HashMap<String, String> itemMap = new HashMap<String, String>();
                if (link != null) {
                    itemMap.put("link", link.getNodeValue());
                }
                if (label != null) {
                    itemMap.put("label", label.getNodeValue());
                }
                if (switchTo != null) {
                    itemMap.put("switchTo", switchTo.getNodeValue());
                }
                items.add(itemMap);
            }
        }
        catch (ParserConfigurationException | DOMException | SAXException e) {
            // empty catch block
        }
        widget.put("items", items);
        view.put("widget", widget);
        Writer writer = env.getOut();
        writer.write(String.format("<ins class=\"view\">%s</ins>", org.nuxeo.theme.html.Utils.toJson(view)));
    }
}

