/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.transaction;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.transaction.TransactionRuntimeException;

public class TransactionHelper {
    private static final Log log = LogFactory.getLog(TransactionHelper.class);
    private static ThreadLocal<List<Exception>> suppressedExceptions = new ThreadLocal();

    private TransactionHelper() {
    }

    public static UserTransaction lookupUserTransaction() throws NamingException {
        UserTransaction ut = NuxeoContainer.getUserTransaction();
        if (ut == null) {
            throw new NamingException("tx manager not installed");
        }
        return ut;
    }

    public static String getUserTransactionJNDIName() {
        return NuxeoContainer.nameOf("UserTransaction");
    }

    public static TransactionManager lookupTransactionManager() throws NamingException {
        TransactionManager tm = NuxeoContainer.getTransactionManager();
        if (tm == null) {
            throw new NamingException("tx manager not installed");
        }
        return tm;
    }

    public static TransactionSynchronizationRegistry lookupSynchronizationRegistry() throws NamingException {
        TransactionSynchronizationRegistry synch = NuxeoContainer.getTransactionSynchronizationRegistry();
        if (synch == null) {
            throw new NamingException("tx manager not installed");
        }
        return synch;
    }

    public static boolean isNoTransaction() {
        try {
            return TransactionHelper.lookupUserTransaction().getStatus() == 6;
        }
        catch (NamingException | SystemException cause) {
            return true;
        }
    }

    public static boolean isTransactionActive() {
        try {
            return TransactionHelper.lookupUserTransaction().getStatus() == 0;
        }
        catch (NamingException | SystemException e) {
            return false;
        }
    }

    public static boolean isTransactionMarkedRollback() {
        try {
            return TransactionHelper.lookupUserTransaction().getStatus() == 1;
        }
        catch (NamingException | SystemException e) {
            return false;
        }
    }

    public static boolean isTransactionActiveOrMarkedRollback() {
        try {
            int status = TransactionHelper.lookupUserTransaction().getStatus();
            return status == 0 || status == 1;
        }
        catch (NamingException | SystemException e) {
            return false;
        }
    }

    public static boolean isTransactionTimedOut() {
        TransactionManager tm = NuxeoContainer.getTransactionManager();
        if (tm == null) {
            return false;
        }
        try {
            Transaction tx = tm.getTransaction();
            if (tx == null || tx.getStatus() != 0) {
                return false;
            }
            if (tx instanceof TransactionImpl) {
                Field f = tx.getClass().getDeclaredField("timeout");
                f.setAccessible(true);
                Long timeout = (Long)f.get(tx);
                return System.currentTimeMillis() > timeout;
            }
            return false;
        }
        catch (ReflectiveOperationException | SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean startTransaction() {
        UserTransaction ut = NuxeoContainer.getUserTransaction();
        if (ut == null) {
            return false;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting transaction");
            }
            ut.begin();
            return true;
        }
        catch (NotSupportedException | SystemException e) {
            log.error((Object)"Unable to start transaction", e);
            return false;
        }
    }

    public static Transaction requireNewTransaction() {
        TransactionManager tm = NuxeoContainer.getTransactionManager();
        if (tm == null) {
            return null;
        }
        try {
            Transaction tx = tm.getTransaction();
            if (tx != null) {
                tx = tm.suspend();
            }
            tm.begin();
            return tx;
        }
        catch (NotSupportedException | SystemException e) {
            throw new TransactionRuntimeException("Cannot suspend tx", e);
        }
    }

    public static Transaction suspendTransaction() {
        TransactionManager tm = NuxeoContainer.getTransactionManager();
        if (tm == null) {
            return null;
        }
        try {
            Transaction tx = tm.getTransaction();
            if (tx != null) {
                tx = tm.suspend();
            }
            return tx;
        }
        catch (SystemException e) {
            throw new TransactionRuntimeException("Cannot suspend tx", e);
        }
    }

    public static void resumeTransaction(Transaction tx) {
        TransactionManager tm = NuxeoContainer.getTransactionManager();
        if (tm == null) {
            return;
        }
        try {
            if (tm.getStatus() == 0) {
                tm.commit();
            }
            if (tx != null) {
                tm.resume(tx);
            }
        }
        catch (IllegalStateException | SecurityException | HeuristicMixedException | HeuristicRollbackException | InvalidTransactionException | RollbackException | SystemException e) {
            throw new TransactionRuntimeException("Cannot resume tx", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean startTransaction(int timeout) {
        TransactionManager tm;
        if (timeout < 0) {
            timeout = 0;
        }
        if ((tm = NuxeoContainer.getTransactionManager()) == null) {
            return false;
        }
        try {
            tm.setTransactionTimeout(timeout);
        }
        catch (SystemException e) {
            log.error((Object)("Unable to set transaction timeout: " + timeout), (Throwable)e);
            return false;
        }
        try {
            boolean bl = TransactionHelper.startTransaction();
            return bl;
        }
        finally {
            try {
                tm.setTransactionTimeout(0);
            }
            catch (SystemException e) {
                log.error((Object)"Unable to reset transaction timeout", (Throwable)e);
            }
        }
    }

    public static void commitOrRollbackTransaction() {
        UserTransaction ut = NuxeoContainer.getUserTransaction();
        if (ut == null) {
            return;
        }
        try {
            int status = ut.getStatus();
            if (status == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Commiting transaction");
                }
                ut.commit();
            } else if (status == 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Cannot commit transaction because it is marked rollback only");
                }
                ut.rollback();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot commit transaction with unknown status: " + status));
            }
        }
        catch (IllegalStateException | SecurityException | HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
            String msg = "Unable to commit/rollback  " + ut;
            if (e instanceof RollbackException && "Unable to commit: transaction marked for rollback".equals(e.getMessage())) {
                log.debug((Object)msg, e);
            } else {
                log.error((Object)msg, e);
            }
            throw new TransactionRuntimeException(msg, e);
        }
    }

    public static void noteSuppressedExceptions() {
        suppressedExceptions.set(new ArrayList(1));
    }

    public static void noteSuppressedException(Exception e) {
        List<Exception> exceptions = suppressedExceptions.get();
        if (exceptions != null) {
            exceptions.add(e);
        }
    }

    public static List<Exception> getSuppressedExceptions() {
        List<Exception> exceptions = suppressedExceptions.get();
        suppressedExceptions.remove();
        return exceptions == null ? Collections.emptyList() : exceptions;
    }

    public static boolean setTransactionRollbackOnly() {
        UserTransaction ut;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting transaction as rollback only");
            if (log.isTraceEnabled()) {
                log.trace((Object)"Rollback stack trace", new Throwable("Rollback stack trace"));
            }
        }
        if ((ut = NuxeoContainer.getUserTransaction()) == null) {
            return false;
        }
        try {
            ut.setRollbackOnly();
            return true;
        }
        catch (IllegalStateException | SystemException cause) {
            log.error((Object)"Could not mark transaction as rollback only", cause);
            return false;
        }
    }

    public static boolean setTransactionRollbackOnlyIfTimedOut() {
        if (TransactionHelper.isTransactionTimedOut()) {
            return TransactionHelper.setTransactionRollbackOnly();
        }
        return false;
    }

    public static void registerSynchronization(Synchronization handler) {
        if (!TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            return;
        }
        try {
            NuxeoContainer.getTransactionManager().getTransaction().registerSynchronization(handler);
        }
        catch (IllegalStateException | RollbackException | SystemException cause) {
            throw new RuntimeException("Cannot register synch handler in current tx", cause);
        }
    }
}

