/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.DefaultStreamBlob;
import org.nuxeo.ecm.core.storage.binary.Binary;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBlob;

public class StorageBlob
extends DefaultStreamBlob
implements SQLBlob {
    private static final long serialVersionUID = 1L;
    protected final Binary binary;
    protected final long length;

    public StorageBlob(Binary binary, String filename, String mimeType, String encoding, String digest, long length) {
        this.binary = binary;
        this.length = length;
        this.setFilename(filename);
        this.setMimeType(mimeType);
        this.setEncoding(encoding);
        this.setDigest(digest);
    }

    public long getLength() {
        return this.length;
    }

    public InputStream getStream() throws IOException {
        return this.binary.getStream();
    }

    public boolean isPersistent() {
        return true;
    }

    public Blob persist() {
        return this;
    }

    @Override
    public Binary getBinary() {
        return this.binary;
    }

    public String getDigest() {
        String digest = super.getDigest();
        if (digest == null) {
            return this.binary.getDigest();
        }
        return digest;
    }

    protected boolean equalsStream(Blob blob) {
        if (!(blob instanceof StorageBlob)) {
            return super.equalsStream(blob);
        }
        StorageBlob other = (StorageBlob)blob;
        if (this.binary == null) {
            return other.binary == null;
        }
        if (other.binary == null) {
            return false;
        }
        return this.binary.getDigest().equals(other.binary.getDigest());
    }
}

