/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.CleanupHandler;
import org.nuxeo.ecm.automation.LoginStack;
import org.nuxeo.ecm.automation.OperationCallback;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.trace.Trace;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class OperationContext
implements Map<String, Object> {
    private static final Log log = LogFactory.getLog(OperationContext.class);
    protected Map<String, Object> vars;
    protected boolean commit = true;
    protected final transient List<CleanupHandler> cleanupHandlers;
    protected final transient Map<String, List<Object>> stacks = new HashMap<String, List<Object>>();
    protected transient LoginStack loginStack;
    protected Object input;
    protected List<String> trace;
    protected ChainCallback chainCallback;

    public OperationContext() {
        this(null, null);
    }

    public OperationContext(CoreSession session) {
        this(session, null);
    }

    public OperationContext(CoreSession session, Map<String, Object> vars) {
        this.cleanupHandlers = new ArrayList<CleanupHandler>();
        this.loginStack = new LoginStack(session);
        this.trace = new ArrayList<String>();
        this.chainCallback = new ChainCallback();
        this.vars = vars != null ? vars : new HashMap();
    }

    public void setCoreSession(CoreSession session) {
        this.loginStack.setSession(session);
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public boolean isCommit() {
        return this.commit;
    }

    public CoreSession getCoreSession() {
        return this.loginStack.getSession();
    }

    public LoginStack getLoginStack() {
        return this.loginStack;
    }

    public Principal getPrincipal() {
        CoreSession session = this.loginStack.getSession();
        return session != null ? session.getPrincipal() : null;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public Object getInput() {
        return this.input;
    }

    public Object peek(String type) {
        List<Object> stack = this.stacks.get(type);
        if (stack == null) {
            return null;
        }
        return stack.isEmpty() ? null : stack.get(stack.size() - 1);
    }

    public void push(String type, Object obj) {
        List<Object> stack = this.stacks.get(type);
        if (stack == null) {
            stack = new ArrayList<Object>();
            this.stacks.put(type, stack);
        }
        stack.add(obj);
    }

    public Object pop(String type) {
        List<Object> stack = this.stacks.get(type);
        if (stack == null) {
            return null;
        }
        return stack.isEmpty() ? null : stack.remove(stack.size() - 1);
    }

    public Object pull(String type) {
        List<Object> stack = this.stacks.get(type);
        if (stack == null) {
            return null;
        }
        return stack.isEmpty() ? null : stack.remove(0);
    }

    public <T> T getAdapter(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(CoreSession.class)) {
            return type.cast(this.getCoreSession());
        }
        if (type.isAssignableFrom(Principal.class)) {
            return type.cast(this.getPrincipal());
        }
        return (T)Framework.getService(type);
    }

    @Deprecated
    public void addTrace(String trace) {
        this.trace.add(trace);
    }

    @Deprecated
    public List<String> getTrace() {
        return this.trace;
    }

    @Deprecated
    public String getFormattedTrace() {
        String crlf = System.getProperty("line.separator");
        StringBuilder buf = new StringBuilder();
        for (String t : this.trace) {
            buf.append("> ").append(t).append(crlf);
        }
        return buf.toString();
    }

    public void addCleanupHandler(CleanupHandler handler) {
        this.cleanupHandlers.add(handler);
    }

    public void removeCleanupHandler(CleanupHandler handler) {
        this.cleanupHandlers.remove(handler);
    }

    public void dispose() throws OperationException {
        this.trace.clear();
        this.loginStack.clear();
        for (CleanupHandler handler : this.cleanupHandlers) {
            handler.cleanup();
        }
    }

    public void setRollback() {
        this.setCommit(false);
        TransactionHelper.setTransactionRollbackOnly();
    }

    public Map<String, Object> getVars() {
        return this.vars;
    }

    @Override
    public int size() {
        return this.vars.size();
    }

    @Override
    public boolean isEmpty() {
        return this.vars.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.vars.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.vars.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.vars.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.vars.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.vars.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.vars.putAll(m);
    }

    @Override
    public void clear() {
        this.vars.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.vars.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.vars.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.vars.entrySet();
    }

    public OperationCallback getChainCallback() {
        return this.chainCallback.operationCallback;
    }

    public void addChainCallback(OperationCallback chainCallback) {
        this.chainCallback.set(chainCallback);
    }

    public OperationContext getSubContext(Boolean isolate, Object input) {
        Map<String, Object> vars = isolate != false ? new HashMap<String, Object>(this.getVars()) : this.getVars();
        OperationContext subctx = new OperationContext(this.getCoreSession(), vars);
        subctx.setInput(input);
        subctx.addChainCallback(this.getChainCallback());
        return subctx;
    }

    protected static class ChainCallback
    implements OperationCallback {
        public OperationCallback operationCallback;

        protected ChainCallback() {
        }

        protected void set(OperationCallback callback) {
            this.operationCallback = callback;
        }

        @Override
        public void onChain(OperationType chain) {
            this.operationCallback.onChain(chain);
        }

        @Override
        public void onOperation(OperationContext context, OperationType type, InvokableMethod method, Map<String, Object> parms) {
            this.operationCallback.onOperation(context, type, method, parms);
        }

        @Override
        public void onError(OperationException error) {
            this.operationCallback.onError(error);
        }

        @Override
        public void onOutput(Object output) {
            this.operationCallback.onOutput(output);
        }

        @Override
        public Trace getTrace() {
            return this.operationCallback.getTrace();
        }

        @Override
        public String getFormattedText() {
            throw new UnsupportedOperationException("#getFormattedText is not available for: " + this);
        }
    }
}

