/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core;

import java.util.ArrayList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationAdmin;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.TypeAdapter;
import org.nuxeo.ecm.automation.core.AutomationFilterDescriptor;
import org.nuxeo.ecm.automation.core.ChainExceptionDescriptor;
import org.nuxeo.ecm.automation.core.OperationChainContribution;
import org.nuxeo.ecm.automation.core.OperationContribution;
import org.nuxeo.ecm.automation.core.TypeAdapterContribution;
import org.nuxeo.ecm.automation.core.events.EventHandler;
import org.nuxeo.ecm.automation.core.events.EventHandlerRegistry;
import org.nuxeo.ecm.automation.core.exception.ChainExceptionFilter;
import org.nuxeo.ecm.automation.core.exception.ChainExceptionImpl;
import org.nuxeo.ecm.automation.core.impl.ChainTypeImpl;
import org.nuxeo.ecm.automation.core.impl.OperationServiceImpl;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetDescriptor;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ServerLocator;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class AutomationComponent
extends DefaultComponent {
    private static final Log log = LogFactory.getLog(AutomationComponent.class);
    public static final String XP_OPERATIONS = "operations";
    public static final String XP_ADAPTERS = "adapters";
    public static final String XP_CHAINS = "chains";
    public static final String XP_EVENT_HANDLERS = "event-handlers";
    public static final String XP_CHAIN_EXCEPTION = "chainException";
    public static final String XP_AUTOMATION_FILTER = "automationFilter";
    protected OperationServiceImpl service;
    protected EventHandlerRegistry handlers;
    protected TracerFactory tracerFactory;

    public void activate(ComponentContext context) {
        this.service = new OperationServiceImpl();
        this.tracerFactory = new TracerFactory();
        this.handlers = new EventHandlerRegistry(this.service);
    }

    protected void bindManagement() throws JMException {
        ObjectName objectName = new ObjectName("org.nuxeo.automation:name=tracerfactory");
        MBeanServer mBeanServer = ((ServerLocator)Framework.getLocalService(ServerLocator.class)).lookupServer();
        mBeanServer.registerMBean(this.tracerFactory, objectName);
    }

    protected void unBindManagement() throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException, InstanceNotFoundException {
        ObjectName on = new ObjectName("org.nuxeo.automation:name=tracerfactory");
        ServerLocator locator = (ServerLocator)Framework.getLocalService(ServerLocator.class);
        if (locator != null) {
            MBeanServer mBeanServer = locator.lookupServer();
            mBeanServer.unregisterMBean(on);
        }
    }

    public void deactivate(ComponentContext context) {
        this.service = null;
        this.handlers = null;
        this.tracerFactory = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_OPERATIONS.equals(extensionPoint)) {
            OperationContribution opc = (OperationContribution)contribution;
            ArrayList<WidgetDefinition> widgetDefinitionList = new ArrayList<WidgetDefinition>();
            if (opc.widgets != null) {
                for (WidgetDescriptor widgetDescriptor : opc.widgets) {
                    widgetDefinitionList.add(widgetDescriptor.getWidgetDefinition());
                }
            }
            try {
                this.service.putOperation(opc.type, opc.replace, contributor.getName().toString(), widgetDefinitionList);
            }
            catch (OperationException e) {
                throw new RuntimeException(e);
            }
        }
        if (XP_CHAINS.equals(extensionPoint)) {
            OperationChainContribution occ = (OperationChainContribution)contribution;
            try {
                ChainTypeImpl docChainType = new ChainTypeImpl(this.service, occ.toOperationChain(contributor.getContext().getBundle()), occ);
                this.service.putOperation(docChainType, occ.replace);
            }
            catch (OperationException e) {
                throw new RuntimeException(e);
            }
        }
        if (XP_CHAIN_EXCEPTION.equals(extensionPoint)) {
            ChainExceptionDescriptor chainExceptionDescriptor = (ChainExceptionDescriptor)contribution;
            ChainExceptionImpl chainException = new ChainExceptionImpl(chainExceptionDescriptor);
            this.service.putChainException(chainException);
        } else if (XP_AUTOMATION_FILTER.equals(extensionPoint)) {
            AutomationFilterDescriptor automationFilterDescriptor = (AutomationFilterDescriptor)contribution;
            ChainExceptionFilter chainExceptionFilter = new ChainExceptionFilter(automationFilterDescriptor);
            this.service.putAutomationFilter(chainExceptionFilter);
        } else if (XP_ADAPTERS.equals(extensionPoint)) {
            TypeAdapter adapter;
            TypeAdapterContribution tac = (TypeAdapterContribution)contribution;
            try {
                adapter = tac.clazz.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            this.service.putTypeAdapter(tac.accept, tac.produce, adapter);
        } else if (XP_EVENT_HANDLERS.equals(extensionPoint)) {
            EventHandler eh = (EventHandler)contribution;
            if (eh.isPostCommit()) {
                this.handlers.putPostCommitEventHandler(eh);
            } else {
                this.handlers.putEventHandler(eh);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_OPERATIONS.equals(extensionPoint)) {
            this.service.removeOperation(((OperationContribution)contribution).type);
        } else if (XP_CHAINS.equals(extensionPoint)) {
            OperationChainContribution occ = (OperationChainContribution)contribution;
            this.service.removeOperationChain(occ.getId());
        } else if (XP_CHAIN_EXCEPTION.equals(extensionPoint)) {
            ChainExceptionDescriptor chainExceptionDescriptor = (ChainExceptionDescriptor)contribution;
            ChainExceptionImpl chainException = new ChainExceptionImpl(chainExceptionDescriptor);
            this.service.removeExceptionChain(chainException);
        } else if (XP_AUTOMATION_FILTER.equals(extensionPoint)) {
            AutomationFilterDescriptor automationFilterDescriptor = (AutomationFilterDescriptor)contribution;
            ChainExceptionFilter automationFilter = new ChainExceptionFilter(automationFilterDescriptor);
            this.service.removeAutomationFilter(automationFilter);
        } else if (XP_ADAPTERS.equals(extensionPoint)) {
            TypeAdapterContribution tac = (TypeAdapterContribution)contribution;
            this.service.removeTypeAdapter(tac.accept, tac.produce);
        } else if (XP_EVENT_HANDLERS.equals(extensionPoint)) {
            EventHandler eh = (EventHandler)contribution;
            if (eh.isPostCommit()) {
                this.handlers.removePostCommitEventHandler(eh);
            } else {
                this.handlers.removeEventHandler(eh);
            }
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == AutomationService.class || adapter == AutomationAdmin.class) {
            return adapter.cast(this.service);
        }
        if (adapter == EventHandlerRegistry.class) {
            return adapter.cast(this.handlers);
        }
        if (adapter == TracerFactory.class) {
            return adapter.cast(this.tracerFactory);
        }
        return null;
    }

    public void applicationStarted(ComponentContext context) {
        super.applicationStarted(context);
        if (!this.tracerFactory.getRecordingState()) {
            log.info((Object)"You can activate automation trace mode to get more informations on automation executions");
        }
        try {
            this.bindManagement();
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        Framework.addListener((RuntimeServiceListener)new RuntimeServiceListener(){

            public void handleEvent(RuntimeServiceEvent event) {
                if (event.id != 2) {
                    return;
                }
                Framework.removeListener((RuntimeServiceListener)this);
                try {
                    AutomationComponent.this.unBindManagement();
                }
                catch (InstanceAlreadyExistsException | InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException cause) {
                    log.error((Object)"Cannot unbind management", (Throwable)cause);
                }
            }
        });
    }
}

