/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.OperationChainContribution;
import org.nuxeo.ecm.automation.core.impl.CompiledChainImpl;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.impl.OperationTypeImpl;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;

public class ChainTypeImpl
implements OperationType {
    protected final OperationChain chain;
    protected Map<String, Object> chainParameters;
    protected AutomationService service;
    protected String id;
    protected final String[] aliases;
    protected OperationDocumentation.Param[] params;
    protected InvokableMethod[] methods = new InvokableMethod[]{this.runMethod()};
    protected String contributingComponent;
    protected OperationParameters[] operations;
    protected OperationChainContribution contribution;
    protected Class<?> outputChain;
    protected InvokableMethod method;

    public ChainTypeImpl(AutomationService service, OperationChain chain) {
        this.service = service;
        this.operations = chain.getOperations().toArray(new OperationParameters[chain.getOperations().size()]);
        this.id = chain.getId();
        this.aliases = chain.getAliases();
        this.chainParameters = chain.getChainParameters();
        this.chain = chain;
    }

    public ChainTypeImpl(AutomationService service, OperationChain chain, OperationChainContribution contribution) {
        this.service = service;
        this.operations = chain.getOperations().toArray(new OperationParameters[chain.getOperations().size()]);
        this.id = chain.getId();
        this.aliases = chain.getAliases();
        this.chainParameters = chain.getChainParameters();
        this.contribution = contribution;
        this.chain = chain;
    }

    public OperationChain getChain() {
        return this.chain;
    }

    public Map<String, Object> getChainParameters() {
        return this.chainParameters;
    }

    @Override
    public Object newInstance(OperationContext ctx, Map<String, Object> args) throws OperationNotFoundException, InvalidChainException {
        Object input = ctx.getInput();
        Class<Void> inputType = input == null ? Void.TYPE : input.getClass();
        CompiledChainImpl op = CompiledChainImpl.buildChain(this.service, inputType, this.operations);
        op.context = ctx;
        return op;
    }

    @Override
    public AutomationService getService() {
        return this.service;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public Class<?> getType() {
        return CompiledChainImpl.class;
    }

    @Override
    public OperationDocumentation getDocumentation() throws OperationException {
        OperationDocumentation doc = new OperationDocumentation(this.id);
        doc.label = this.id;
        doc.requires = this.contribution.getRequires();
        doc.category = this.contribution.getCategory();
        doc.setAliases(this.contribution.getAliases());
        OperationChainContribution.Operation[] operations = this.contribution.getOps();
        doc.operations = operations;
        doc.since = this.contribution.getSince();
        if (doc.requires.length() == 0) {
            doc.requires = null;
        }
        if (doc.label.length() == 0) {
            doc.label = doc.id;
        }
        doc.description = this.contribution.getDescription();
        doc.params = this.contribution.getParams();
        if (operations.length != 0) {
            ArrayList<String> result = this.getSignature(operations);
            doc.signature = result.toArray(new String[result.size()]);
        } else {
            doc.signature = new String[]{"void", "void"};
        }
        return doc;
    }

    protected ArrayList<String> getSignature(OperationChainContribution.Operation[] operations) throws OperationException {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> collectedSigs = new HashSet<String>();
        OperationType operationType = this.service.getOperation(operations[0].getId());
        for (InvokableMethod method : operationType.getMethods()) {
            String inputChain = this.getParamDocumentationType(method.getInputType(), method.isIterable());
            this.outputChain = method.getInputType();
            String outputChain = this.getParamDocumentationType(this.getChainOutput(operations));
            String sigKey = inputChain + ":" + outputChain;
            if (collectedSigs.contains(sigKey)) continue;
            result.add(inputChain);
            result.add(outputChain);
            collectedSigs.add(sigKey);
        }
        return result;
    }

    protected Class<?> getChainOutput(OperationChainContribution.Operation[] operations) throws OperationException {
        for (OperationChainContribution.Operation operation : operations) {
            OperationType operationType = this.service.getOperation(operation.getId());
            this.outputChain = operationType instanceof OperationTypeImpl ? this.getOperationOutput(this.outputChain, operationType) : this.getChainOutput(operationType.getDocumentation().getOperations());
        }
        return this.outputChain;
    }

    public Class<?> getOperationOutput(Class<?> input, OperationType operationType) {
        InvokableMethod[] methods = operationType.getMethodsMatchingInput(input);
        if (methods == null || methods.length == 0) {
            return input;
        }
        InvokableMethod topMethod = this.getTopMethod(methods);
        Class<?> nextInput = topMethod.getOutputType();
        if (nextInput == Void.TYPE) {
            return input;
        }
        return nextInput;
    }

    protected InvokableMethod getTopMethod(InvokableMethod[] methods) {
        InvokableMethod topMethod = methods[0];
        for (InvokableMethod method : methods) {
            if (method.getPriority() <= topMethod.getPriority()) continue;
            topMethod = method;
        }
        return topMethod;
    }

    @Override
    public String getContributingComponent() {
        return this.contributingComponent;
    }

    @Override
    public InvokableMethod[] getMethodsMatchingInput(Class<?> in) {
        return this.methods;
    }

    protected InvokableMethod runMethod() {
        try {
            return new InvokableMethod(this, CompiledChainImpl.class.getMethod("run", new Class[0]));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new UnsupportedOperationException("Cannot use reflection for run method", e);
        }
    }

    protected String getParamDocumentationType(Class<?> type) {
        return this.getParamDocumentationType(type, false);
    }

    protected String getParamDocumentationType(Class<?> type, boolean isIterable) {
        String t = DocumentModel.class.isAssignableFrom(type) || DocumentRef.class.isAssignableFrom(type) ? (isIterable ? "documents" : "document") : (DocumentModelList.class.isAssignableFrom(type) || DocumentRefList.class.isAssignableFrom(type) ? "documents" : (BlobList.class.isAssignableFrom(type) ? "bloblist" : (Blob.class.isAssignableFrom(type) ? (isIterable ? "bloblist" : "blob") : (URL.class.isAssignableFrom(type) ? "resource" : (Calendar.class.isAssignableFrom(type) ? "date" : type.getSimpleName().toLowerCase())))));
        return t;
    }

    public String toString() {
        return "ChainTypeImpl [id=" + this.id + "]";
    }

    public OperationChainContribution getContribution() {
        return this.contribution;
    }

    @Override
    public List<InvokableMethod> getMethods() {
        return Arrays.asList(this.methods);
    }
}

