/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.io.File;
import java.io.IOException;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.BlobCollector;
import org.nuxeo.ecm.core.api.Blob;

@Operation(id="Blob.ToFile", category="Files", label="Export to File", description="Save the input blob(s) as a file(s) into the given target directory. The blob(s) filename is used as the file name. You can specify an optional <b>prefix</b> string to prepend to the file name. Return back the blob(s).")
public class BlobToFile {
    public static final String ID = "Blob.ToFile";
    @Param(name="directory", required=true)
    protected String directory;
    @Param(name="prefix", required=false)
    protected String prefix;
    protected File root;

    protected void init() {
        this.root = new File(this.directory);
        this.root.mkdirs();
    }

    protected File getFile(String name) {
        return new File(this.root, this.prefix != null ? this.prefix + name : name);
    }

    protected void writeFile(Blob blob) throws IOException {
        String name = blob.getFilename();
        if (name.length() == 0) {
            name = "blob#" + Integer.toHexString(System.identityHashCode(blob));
        }
        File file = this.getFile(name);
        File tmp = new File(file.getParentFile(), file.getName() + ".tmp");
        blob.transferTo(tmp);
        tmp.renameTo(file);
    }

    @OperationMethod(collector=BlobCollector.class)
    public Blob run(Blob blob) throws IOException {
        this.init();
        this.writeFile(blob);
        return blob;
    }
}

