/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.util.HashMap;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;

@Operation(id="Blob.ToPDF", category="Conversion", label="Convert To PDF", description="Convert the input file to a PDF and return the new file.")
public class BlobToPDF {
    public static final String ID = "Blob.ToPDF";
    @Context
    protected ConversionService service;

    @OperationMethod
    public Blob run(DocumentModel doc) {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            return null;
        }
        if ("application/pdf".equals(bh.getBlob().getMimeType())) {
            return bh.getBlob();
        }
        BlobHolder pdfBh = this.service.convertToMimeType("application/pdf", bh, new HashMap());
        Blob result = pdfBh.getBlob();
        String fname = result.getFilename();
        String filename = bh.getBlob().getFilename();
        if (filename != null && !filename.isEmpty()) {
            int pos = filename.lastIndexOf(46);
            if (pos > 0) {
                filename = filename.substring(0, pos);
            }
            filename = filename + ".pdf";
            result.setFilename(filename);
        } else if (fname != null && !fname.isEmpty()) {
            result.setFilename(fname);
        } else {
            result.setFilename("file");
        }
        result.setMimeType("application/pdf");
        return result;
    }

    @OperationMethod
    public Blob run(Blob blob) {
        if ("application/pdf".equals(blob.getMimeType())) {
            return blob;
        }
        SimpleBlobHolder bh = new SimpleBlobHolder(blob);
        bh = this.service.convertToMimeType("application/pdf", (BlobHolder)bh, new HashMap());
        Blob result = bh.getBlob();
        this.adjustBlobName(blob, result);
        return result;
    }

    @OperationMethod
    public BlobList run(BlobList blobs) {
        BlobList bl = new BlobList();
        for (Blob blob : blobs) {
            bl.add(this.run(blob));
        }
        return bl;
    }

    protected void adjustBlobName(Blob in, Blob out) {
        String fname = in.getFilename();
        if (fname == null) {
            fname = "Unknown_" + System.identityHashCode(in);
        }
        out.setFilename(fname + ".pdf");
        out.setMimeType("application/pdf");
    }
}

