/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.execution;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Context.RunOperationOnList", category="Execution Flow", label="Run For Each", description="Run an operation for each element from the list defined by the 'list' parameter. The 'list' parameter is pointing to a context variable that represents the list which will be iterated. The 'item' parameter represents the name of the context variable which will point to the current element in the list at each iteration. You can use the 'isolate' parameter to specify whether or not the evalution context is the same as the parent context or a copy of it. If the 'isolate' parameter is 'true' then a copy of the current context is used and so that modifications in this context will not affect the parent context. Any input is accepted. The input is returned back as output when operation terminates. The 'parameters' injected are accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.")
public class RunOperationOnList {
    public static final String ID = "Context.RunOperationOnList";
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;
    @Context
    protected CoreSession session;
    @Param(name="id")
    protected String chainId;
    @Param(name="list")
    protected String listName;
    @Param(name="item", required=false, values={"item"})
    protected String itemName = "item";
    @Param(name="isolate", required=false, values={"true"})
    protected boolean isolate = true;
    @Param(name="parameters", description="Accessible in the subcontext ChainParameters. For instance, @{ChainParameters['parameterKey']}.", required=false)
    protected Properties chainParameters;
    @Param(name="newTx", required=false, values={"false"}, description="Define if the chain in parameter should be executed in new transaction.")
    protected boolean newTx = false;
    @Param(name="timeout", required=false, description="Define transaction timeout (default to 60 sec).")
    protected Integer timeout = 60;
    @Param(name="rollbackGlobalOnError", required=false, values={"true"}, description="Define if transaction should rollback or not (default to true)")
    protected boolean rollbackGlobalOnError = true;

    @OperationMethod
    public void run() throws OperationException {
        Map<String, Object> vars = this.isolate ? new HashMap<String, Object>(this.ctx.getVars()) : this.ctx.getVars();
        OperationContext subctx = this.ctx.getSubContext(this.isolate, this.ctx.getInput());
        Collection<Object> list = null;
        if (this.ctx.get(this.listName) instanceof Object[]) {
            list = Arrays.asList((Object[])this.ctx.get(this.listName));
        } else if (this.ctx.get(this.listName) instanceof Collection) {
            list = (Collection)this.ctx.get(this.listName);
        } else {
            throw new UnsupportedOperationException(this.ctx.get(this.listName).getClass() + " is not a Collection");
        }
        for (Object e : list) {
            subctx.put(this.itemName, e);
            if (this.newTx) {
                this.service.runInNewTx(subctx, this.chainId, this.chainParameters, this.timeout, this.rollbackGlobalOnError);
                continue;
            }
            this.service.run(subctx, this.chainId, this.chainParameters);
        }
        if (!this.isolate) {
            for (String string : vars.keySet()) {
                if (!this.ctx.getVars().containsKey(string)) {
                    this.ctx.put(string, vars.get(string));
                    continue;
                }
                Object value = vars.get(string);
                if (this.session != null && value != null && value instanceof DocumentModel) {
                    this.ctx.getVars().put(string, this.session.getDocument(((DocumentModel)value).getRef()));
                    continue;
                }
                this.ctx.getVars().put(string, value);
            }
        }
    }
}

