/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.stack;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="Document.Pop", category="Push & Pop", label="Pop Document", description="Restore the last saved input document in the context input stack. This operation must be used only if a PUSH operation was previously made. Return the last <i>pushed</i> document.")
public class PopDocument {
    public static final String ID = "Document.Pop";
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public DocumentModel run() throws OperationException {
        Object obj = this.ctx.pop("document");
        if (obj instanceof DocumentModel) {
            return (DocumentModel)obj;
        }
        if (obj instanceof DocumentRef) {
            return this.ctx.getCoreSession().getDocument((DocumentRef)obj);
        }
        throw new OperationException("Illegal state error for pop document operation. The context stack doesn't contains a document on its top");
    }
}

