/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.stack;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Operation(id="Document.PullList", category="Push & Pop", label="Pull Document List", description="Restore the first saved input document list in the context input stack")
public class PullDocumentList {
    public static final String ID = "Document.PullList";
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public DocumentModelList run() throws OperationException {
        Object obj = this.ctx.pull("documents");
        if (obj instanceof DocumentModelList) {
            return (DocumentModelList)obj;
        }
        if (obj instanceof DocumentRefList) {
            CoreSession session = this.ctx.getCoreSession();
            DocumentRefList refs = (DocumentRefList)obj;
            DocumentModelListImpl list = new DocumentModelListImpl((int)refs.totalSize());
            for (DocumentRef ref : refs) {
                list.add((Object)session.getDocument(ref));
            }
        }
        throw new OperationException("Illegal state error for pull document operation. The context stack doesn't contains a document list on its bottom");
    }
}

