/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.rendering.operations;

import freemarker.template.TemplateException;
import java.io.IOException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.BlobCollector;
import org.nuxeo.ecm.automation.core.rendering.RenderingService;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;
import org.nuxeo.runtime.services.resource.ResourceService;

@Operation(id="Render.Document", category="Conversion", label="Render Document", description="Get a document or a list of document in input and outputs one or more blobs that contain a rendered view for each input document given a rendering template. The template attribute may contain either the template content either a template URI. Template URis are strings in the form 'template:template_name' and will be located using the runtime resource service. Return the rendered file(s) as blob(s)")
public class RenderDocument {
    public static final String ID = "Render.Document";
    @Context
    protected ResourceService rs;
    @Context
    protected OperationContext ctx;
    @Param(name="template", widget="TemplateResource")
    protected String template;
    @Param(name="type", widget="Option", required=false, values={"ftl", "mvel"})
    protected String type = "ftl";
    @Param(name="filename", required=false, values={"output.ftl"})
    protected String name = "output.ftl";
    @Param(name="mimetype", required=false, values={"text/xml"})
    protected String mimeType = "text/xml";

    @OperationMethod(collector=BlobCollector.class)
    public Blob run(DocumentModel doc) throws OperationException, RenderingException, TemplateException, IOException {
        String content = RenderingService.getInstance().render(this.type, this.template, this.ctx);
        StringBlob blob = new StringBlob(content);
        blob.setFilename(this.name);
        blob.setMimeType(this.mimeType);
        return blob;
    }
}

