/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.core.util.DateTimeFormat;
import org.nuxeo.ecm.automation.core.util.JSONPropertyWriter;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.webengine.JsonFactoryManager;
import org.nuxeo.runtime.api.Framework;

public class ComplexPropertyJSONEncoder {
    private static JsonFactory getFactory() {
        JsonFactoryManager jsonFactoryManager = (JsonFactoryManager)Framework.getLocalService(JsonFactoryManager.class);
        return jsonFactoryManager.getJsonFactory();
    }

    public static String encode(ComplexProperty cp) throws IOException {
        return ComplexPropertyJSONEncoder.encode(cp, DateTimeFormat.W3C);
    }

    public static String encode(ComplexProperty cp, DateTimeFormat dateTimeFormat) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator jg = ComplexPropertyJSONEncoder.getFactory().createJsonGenerator((OutputStream)out);
        JSONPropertyWriter.writePropertyValue(jg, (Property)cp, dateTimeFormat, null);
        jg.flush();
        jg.close();
        return out.toString("UTF-8");
    }
}

