/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import com.google.common.base.Objects;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.runtime.api.Framework;

public class Properties
extends HashMap<String, String> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTIES_MULTILINE_ESCAPE = "nuxeo.automation.properties.multiline.escape";
    protected static final String multiLineEscape = (String)Objects.firstNonNull((Object)Framework.getProperty((String)"nuxeo.automation.properties.multiline.escape"), (Object)"true");

    public Properties() {
    }

    public Properties(int size) {
        super(size);
    }

    public Properties(Map<String, String> props) {
        super(props);
    }

    public Properties(String content) throws IOException {
        StringReader reader = new StringReader(content);
        Properties.loadProperties(reader, this);
    }

    public Properties(JsonNode node) throws IOException {
        Iterator fields = node.getFields();
        ObjectMapper om = new ObjectMapper();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            JsonNode subNode = (JsonNode)entry.getValue();
            this.put(key, this.extractValueFromNode(subNode, om));
        }
    }

    private String extractValueFromNode(JsonNode node, ObjectMapper om) throws IOException {
        if (!node.isNull()) {
            return node.isContainerNode() ? om.writeValueAsString((Object)node) : node.getValueAsText();
        }
        return null;
    }

    public static Map<String, String> loadProperties(Reader reader) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties.loadProperties(reader, map);
        return map;
    }

    public static void loadProperties(Reader reader, Map<String, String> map) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line = in.readLine();
        String prevLine = null;
        while (line != null) {
            if ((line = line.trim()).startsWith("#") || line.length() == 0) {
                prevLine = null;
                line = in.readLine();
                continue;
            }
            if (line.endsWith("\\") && Boolean.valueOf(multiLineEscape).booleanValue()) {
                line = line.substring(0, line.length() - 1);
                prevLine = prevLine != null ? prevLine + line : line;
                line = in.readLine();
                continue;
            }
            if (prevLine != null) {
                line = prevLine + "\n" + line;
            }
            prevLine = null;
            Properties.setPropertyLine(map, line);
            line = in.readLine();
        }
        if (prevLine != null) {
            Properties.setPropertyLine(map, prevLine);
        }
    }

    protected static void setPropertyLine(Map<String, String> map, String line) throws IOException {
        int i = line.indexOf(61);
        if (i == -1) {
            throw new IOException("Invalid property line: " + line);
        }
        map.put(line.substring(0, i).trim(), line.substring(i + 1).trim());
    }
}

