/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.adapters;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.impl.AbstractResourceAdapter;
import org.nuxeo.ecm.platform.relations.api.impl.QNameResourceImpl;
import org.nuxeo.runtime.api.Framework;

public class DocumentModelResourceAdapter
extends AbstractResourceAdapter
implements Serializable {
    private static final Log log = LogFactory.getLog(DocumentModelResourceAdapter.class);
    private static final long serialVersionUID = -5307418102496342779L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getResourceRepresentation(Resource resource, Map<String, Object> context) {
        DocumentModel object = null;
        if (resource.isQNameResource()) {
            CoreSession session = null;
            boolean sessionOpened = false;
            try {
                String uid;
                String repoName;
                String localName = ((QNameResource)resource).getLocalName();
                int index = localName.indexOf(47);
                if (index == -1) {
                    RepositoryManager mgr = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
                    repoName = mgr.getDefaultRepositoryName();
                    uid = localName;
                } else {
                    repoName = localName.substring(0, index);
                    uid = localName.substring(index + 1);
                }
                IdRef ref = new IdRef(uid);
                if (context != null && !(session = (CoreSession)context.get("CoreSession")).getRepositoryName().equals(repoName)) {
                    session = null;
                }
                if (session == null) {
                    session = CoreInstance.openCoreSession((String)repoName);
                    sessionOpened = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Opened a new session '%s' with id %s", repoName, session.getSessionId()));
                    }
                }
                if (!session.exists((DocumentRef)ref)) {
                    Serializable serializable = null;
                    return serializable;
                }
                object = session.getDocument((DocumentRef)ref);
            }
            catch (ClientException e) {
                log.warn((Object)("Cannot get resource: " + resource), (Throwable)e);
            }
            finally {
                if (sessionOpened) {
                    session.close();
                }
            }
        }
        return object;
    }

    public Resource getResource(Serializable object, Map<String, Object> context) {
        if (object instanceof DocumentModel) {
            DocumentModel doc = (DocumentModel)object;
            String localName = doc.getRepositoryName() + '/' + doc.getId();
            return new QNameResourceImpl(this.namespace, localName);
        }
        if (object instanceof DocumentLocation) {
            DocumentLocation docLoc = (DocumentLocation)object;
            String localName = docLoc.getServerName() + '/' + docLoc.getIdRef().toString();
            return new QNameResourceImpl(this.namespace, localName);
        }
        throw new IllegalArgumentException(String.format("cannot build resource for '%s'", object));
    }

    public Class<?> getKlass() {
        return DocumentModel.class;
    }
}

