/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service.executors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.executors.Executor;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractExecutor
implements Executor {
    @Deprecated
    public static final Pattern VALID_PARAMETER_PATTERN = Pattern.compile("[\\p{L}_0-9-.%:=/\\\\ ]+");

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("windows");
    }

    public static String getParametersString(CommandLineDescriptor cmdDesc, CmdParameters params) {
        String paramString = cmdDesc.getParametersString();
        HashMap<String, CmdParameters.CmdParameter> paramsValues = params.getCmdParameters();
        paramString = AbstractExecutor.replaceParams(paramsValues, paramString);
        return paramString;
    }

    public static String[] getParametersArray(CommandLineDescriptor cmdDesc, CmdParameters params) {
        ArrayList<String> res = new ArrayList<String>();
        String[] paramsArray = cmdDesc.getParametersString().split(" ");
        HashMap<String, CmdParameters.CmdParameter> paramsValues = params.getCmdParameters();
        for (String paramString : paramsArray) {
            res.add(AbstractExecutor.replaceParams(paramsValues, paramString));
        }
        return res.toArray(new String[0]);
    }

    private static String replaceParams(Map<String, CmdParameters.CmdParameter> paramsValues, String paramString) {
        CommandLineExecutorService commandLineExecutorService = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
        for (String pname : paramsValues.keySet()) {
            String param = "#{" + pname + "}";
            if (!paramString.contains(param)) continue;
            CmdParameters.CmdParameter cmdParameter = paramsValues.get(pname);
            String value = cmdParameter.getValue();
            commandLineExecutorService.checkParameter(value);
            if (cmdParameter.isQuote()) {
                paramString = paramString.replace("#{" + pname + "}", String.format("\"%s\"", value));
                continue;
            }
            paramString = paramString.replace("#{" + pname + "}", String.format("%s", value));
        }
        return paramString;
    }
}

