/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ArrayLongList;
import org.apache.commons.collections.primitives.LongIterator;
import org.apache.commons.collections.primitives.LongList;
import org.apache.commons.collections.primitives.LongListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableLongIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableLongList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableLongListIterator;

public final class LongCollections {
    public static final LongList EMPTY_LONG_LIST = LongCollections.unmodifiableLongList(new ArrayLongList(0));
    public static final LongIterator EMPTY_LONG_ITERATOR = LongCollections.unmodifiableLongIterator(EMPTY_LONG_LIST.iterator());
    public static final LongListIterator EMPTY_LONG_LIST_ITERATOR = LongCollections.unmodifiableLongListIterator(EMPTY_LONG_LIST.listIterator());

    private LongCollections() {
    }

    @Nonnull
    public static LongList singletonLongList(long l) {
        ArrayLongList arrayLongList = new ArrayLongList(1);
        arrayLongList.add(l);
        return UnmodifiableLongList.wrap(arrayLongList);
    }

    @Nonnull
    public static LongIterator singletonLongIterator(long l) {
        return LongCollections.singletonLongList(l).iterator();
    }

    @Nonnull
    public static LongListIterator singletonLongListIterator(long l) {
        return LongCollections.singletonLongList(l).listIterator();
    }

    @Nonnull
    public static LongList unmodifiableLongList(@Nonnull LongList longList) throws NullPointerException {
        if (null == longList) {
            throw new NullPointerException();
        }
        return UnmodifiableLongList.wrap(longList);
    }

    @Nonnull
    public static LongIterator unmodifiableLongIterator(@Nonnull LongIterator longIterator) {
        if (null == longIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableLongIterator.wrap(longIterator);
    }

    @Nonnull
    public static LongListIterator unmodifiableLongListIterator(@Nonnull LongListIterator longListIterator) {
        if (null == longListIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableLongListIterator.wrap(longListIterator);
    }

    @Nonnull
    public static LongList getEmptyLongList() {
        return EMPTY_LONG_LIST;
    }

    @Nonnull
    public static LongIterator getEmptyLongIterator() {
        return EMPTY_LONG_ITERATOR;
    }

    @Nonnull
    public static LongListIterator getEmptyLongListIterator() {
        return EMPTY_LONG_LIST_ITERATOR;
    }
}

