/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.DoubleCollection;
import org.apache.commons.collections.primitives.DoubleIterator;
import org.apache.commons.collections.primitives.DoubleList;
import org.apache.commons.collections.primitives.DoubleListIterator;
import org.apache.commons.collections.primitives.adapters.AbstractCollectionDoubleCollection;
import org.apache.commons.collections.primitives.adapters.DoubleCollectionCollection;
import org.apache.commons.collections.primitives.adapters.ListDoubleList;
import org.apache.commons.collections.primitives.adapters.ListIteratorDoubleListIterator;

abstract class AbstractListDoubleList
extends AbstractCollectionDoubleCollection
implements DoubleList {
    AbstractListDoubleList() {
    }

    @Override
    @Nonnull
    protected final Collection<Double> getCollection() {
        return this.getList();
    }

    @Nonnull
    protected abstract List<Double> getList();

    @Override
    public void add(int n, double d) {
        this.getList().add(n, d);
    }

    @Override
    public boolean addAll(int n, @Nonnull DoubleCollection doubleCollection) {
        return this.getList().addAll(n, DoubleCollectionCollection.wrap(doubleCollection));
    }

    @Override
    public double get(int n) {
        return this.getList().get(n);
    }

    @Override
    public int indexOf(double d) {
        return this.getList().indexOf(d);
    }

    @Override
    public int lastIndexOf(double d) {
        return this.getList().lastIndexOf(d);
    }

    @Override
    @Nonnull
    public DoubleListIterator listIterator() {
        return ListIteratorDoubleListIterator.wrap(this.getList().listIterator());
    }

    @Override
    @Nonnull
    public DoubleListIterator listIterator(int n) {
        return ListIteratorDoubleListIterator.wrap(this.getList().listIterator(n));
    }

    @Override
    public double removeElementAt(int n) {
        return this.getList().remove(n);
    }

    @Override
    public double set(int n, double d) {
        return this.getList().set(n, d);
    }

    @Override
    @Nonnull
    public DoubleList subList(int n, int n2) {
        return ListDoubleList.wrap(this.getList().subList(n, n2));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DoubleList)) {
            return false;
        }
        DoubleList doubleList = (DoubleList)object;
        if (this.size() != doubleList.size()) {
            return false;
        }
        DoubleIterator doubleIterator = this.iterator();
        DoubleIterator doubleIterator2 = doubleList.iterator();
        while (doubleIterator.hasNext()) {
            if (doubleIterator.next() == doubleIterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getList()).hashCode();
    }
}

