/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.DoubleIterator;
import org.apache.commons.collections.primitives.decorators.ProxyDoubleIterator;

public final class UnmodifiableDoubleIterator
extends ProxyDoubleIterator {
    private DoubleIterator m_aProxied;

    UnmodifiableDoubleIterator(@Nonnull DoubleIterator doubleIterator) {
        this.m_aProxied = doubleIterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This DoubleIterator is not modifiable.");
    }

    @Override
    @Nonnull
    protected DoubleIterator getIterator() {
        return this.m_aProxied;
    }

    @Nullable
    public static final DoubleIterator wrap(@Nullable DoubleIterator doubleIterator) {
        if (null == doubleIterator) {
            return null;
        }
        if (doubleIterator instanceof UnmodifiableDoubleIterator) {
            return doubleIterator;
        }
        return new UnmodifiableDoubleIterator(doubleIterator);
    }
}

