/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.core.registries;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class LayoutDefinitionRegistry
extends SimpleContributionRegistry<LayoutDefinition> {
    protected final String category;

    public LayoutDefinitionRegistry(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public List<String> getLayoutNames() {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(this.currentContribs.keySet());
        return res;
    }

    public String getContributionId(LayoutDefinition contrib) {
        return contrib.getName();
    }

    public LayoutDefinition getLayoutDefinition(String id) {
        return (LayoutDefinition)this.getCurrentContribution(id);
    }

    public synchronized void addContribution(LayoutDefinition contrib) {
        super.addContribution((Object)contrib);
        List aliases = contrib.getAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                ContributionFragmentRegistry.FragmentList head = this.addFragment(alias, contrib);
                this.contributionUpdated(alias, head.merge((ContributionFragmentRegistry)this), contrib);
            }
        }
    }

    public synchronized void removeContribution(LayoutDefinition contrib, boolean useEqualsMethod) {
        super.removeContribution((Object)contrib, useEqualsMethod);
        List aliases = contrib.getAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                ContributionFragmentRegistry.FragmentList head = this.removeFragment(alias, contrib, useEqualsMethod);
                if (head == null) continue;
                LayoutDefinition result = (LayoutDefinition)head.merge((ContributionFragmentRegistry)this);
                if (result != null) {
                    this.contributionUpdated(alias, result, contrib);
                    continue;
                }
                this.contributionRemoved(alias, contrib);
            }
        }
    }
}

