/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.core.registries;

import java.util.List;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class WidgetDefinitionRegistry
extends SimpleContributionRegistry<WidgetDefinition> {
    protected final String category;

    public WidgetDefinitionRegistry(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public String getContributionId(WidgetDefinition contrib) {
        return contrib.getName();
    }

    public WidgetDefinition getWidgetDefinition(String id) {
        return (WidgetDefinition)this.getCurrentContribution(id);
    }

    public synchronized void addContribution(WidgetDefinition contrib) {
        super.addContribution((Object)contrib);
        List aliases = contrib.getAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                ContributionFragmentRegistry.FragmentList head = this.addFragment(alias, contrib);
                this.contributionUpdated(alias, head.merge((ContributionFragmentRegistry)this), contrib);
            }
        }
    }

    public synchronized void removeContribution(WidgetDefinition contrib, boolean useEqualsMethod) {
        super.removeContribution((Object)contrib, useEqualsMethod);
        List aliases = contrib.getAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                ContributionFragmentRegistry.FragmentList head = this.removeFragment(alias, contrib, useEqualsMethod);
                if (head == null) continue;
                WidgetDefinition result = (WidgetDefinition)head.merge((ContributionFragmentRegistry)this);
                if (result != null) {
                    this.contributionUpdated(alias, result, contrib);
                    continue;
                }
                this.contributionRemoved(alias, contrib);
            }
        }
    }
}

