/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.nuxeo.ecm.core.api.Blob;

public abstract class AbstractBlob
implements Blob {
    public static final String EMPTY_STRING = "";
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final InputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(EMPTY_BYTE_ARRAY);
    public static final Reader EMPTY_READER = new StringReader("");
    protected static final int BUFFER_SIZE = 65536;

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[65536];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    public static void copy(Reader in, Writer out) throws IOException {
        int read;
        char[] buffer = new char[65536];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferTo(Writer writer) throws IOException {
        Reader reader = this.getReader();
        if (reader != null && reader != EMPTY_READER) {
            try {
                AbstractBlob.copy(reader, writer);
            }
            finally {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferTo(OutputStream out) throws IOException {
        InputStream in = this.getStream();
        if (in != null && in != EMPTY_INPUT_STREAM) {
            try {
                AbstractBlob.copy(in, out);
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferTo(File file) throws IOException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(file);
            this.transferTo(out);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Blob)) {
            return false;
        }
        Blob other = (Blob)object;
        if (!ObjectUtils.equals((Object)this.getFilename(), (Object)other.getFilename())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.getMimeType(), (Object)other.getMimeType())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.getEncoding(), (Object)other.getEncoding())) {
            return false;
        }
        String digest = this.getDigest();
        String otherDigest = other.getDigest();
        if (digest != null && otherDigest != null && !digest.equals(otherDigest)) {
            return false;
        }
        return this.equalsStream(other);
    }

    protected boolean equalsStream(Blob other) {
        boolean bl;
        InputStream is = null;
        InputStream ois = null;
        try {
            this.persist();
            other.persist();
            is = this.getStream();
            ois = other.getStream();
            bl = IOUtils.contentEquals((InputStream)is, (InputStream)ois);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(ois);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((InputStream)ois);
        return bl;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getFilename()).append((Object)this.getMimeType()).append((Object)this.getEncoding()).toHashCode();
    }
}

