/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.resolver;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.resolver.PropertyObjectResolver;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;
import org.nuxeo.runtime.api.Framework;

public class DocumentPropertyObjectResolverImpl
implements PropertyObjectResolver {
    protected DocumentModel doc;
    protected String xpath;
    protected ObjectResolver resolver;

    public static DocumentPropertyObjectResolverImpl create(DocumentModel doc, String xpath) {
        ObjectResolver resolver;
        Field field = ((SchemaManager)Framework.getService(SchemaManager.class)).getField(xpath);
        if (field != null && (resolver = field.getType().getObjectResolver()) != null) {
            return new DocumentPropertyObjectResolverImpl(doc, xpath, resolver);
        }
        return null;
    }

    public DocumentPropertyObjectResolverImpl(DocumentModel doc, String xpath, ObjectResolver resolver) {
        this.doc = doc;
        this.xpath = xpath;
        this.resolver = resolver;
    }

    @Override
    public boolean validate() {
        return this.resolver.validate((Object)this.doc.getPropertyValue(this.xpath));
    }

    @Override
    public Object fetch() {
        return this.resolver.fetch((Object)this.doc.getPropertyValue(this.xpath));
    }

    @Override
    public <T> T fetch(Class<T> type) {
        return (T)this.resolver.fetch(type, (Object)this.doc.getPropertyValue(this.xpath));
    }

    @Override
    public void setObject(Object object) {
        Serializable reference = this.resolver.getReference(object);
        this.doc.setPropertyValue(this.xpath, reference);
    }

    @Override
    public ObjectResolver getObjectResolver() {
        return this.resolver;
    }
}

