/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.validation;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.validation.DocumentValidationReport;

public class DocumentValidationException
extends ClientException {
    private static final String MESSAGE = "%s constraint violation(s) where thrown. 1st is : %s (call " + DocumentValidationException.class.getSimpleName() + ".getViolations() to get the others)";
    private static final long serialVersionUID = 1L;
    private DocumentValidationReport report;

    public DocumentValidationException(DocumentValidationReport report) {
        this.report = report;
    }

    public DocumentValidationReport getReport() {
        return this.report;
    }

    @Override
    public String getMessage() {
        if (this.report.hasError()) {
            String violationMessage = this.report.asList().get(0).getMessage(null);
            String message = String.format(MESSAGE, this.report.numberOfErrors(), violationMessage);
            return message;
        }
        return super.getMessage();
    }
}

