/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.validation.ConstraintViolation;
import org.nuxeo.ecm.core.api.validation.DocumentValidationDescriptor;
import org.nuxeo.ecm.core.api.validation.DocumentValidationReport;
import org.nuxeo.ecm.core.api.validation.DocumentValidationService;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;
import org.nuxeo.ecm.core.schema.types.constraints.NotNullConstraint;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DocumentValidationServiceImpl
extends DefaultComponent
implements DocumentValidationService {
    private SchemaManager schemaManager;
    private Map<String, Boolean> validationActivations = new HashMap<String, Boolean>();

    protected SchemaManager getSchemaManager() {
        if (this.schemaManager == null) {
            this.schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        }
        return this.schemaManager;
    }

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("activations")) {
            DocumentValidationDescriptor dvd = (DocumentValidationDescriptor)contribution;
            this.validationActivations.put(dvd.getContext(), dvd.isActivated());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("activations")) {
            DocumentValidationDescriptor dvd = (DocumentValidationDescriptor)contribution;
            this.validationActivations.remove(dvd.getContext());
        }
    }

    @Override
    public boolean isActivated(String context, Map<String, Serializable> contextMap) {
        Boolean activated;
        DocumentValidationService.Forcing flag;
        if (contextMap != null && (flag = (DocumentValidationService.Forcing)((Object)contextMap.get("DocumentValidationService.Forcing"))) != null) {
            switch (flag) {
                case TURN_ON: {
                    return true;
                }
                case TURN_OFF: {
                    return false;
                }
            }
        }
        if ((activated = this.validationActivations.get(context)) == null) {
            return false;
        }
        return activated;
    }

    @Override
    public DocumentValidationReport validate(DocumentModel document) {
        return this.validate(document, false);
    }

    @Override
    public DocumentValidationReport validate(DocumentModel document, boolean dirtyOnly) {
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        DocumentType docType = document.getDocumentType();
        if (dirtyOnly) {
            for (DataModel dataModel : document.getDataModels().values()) {
                Schema schemaDef = this.getSchemaManager().getSchema(dataModel.getSchema());
                for (String fieldName : dataModel.getDirtyFields()) {
                    Field field = schemaDef.getField(fieldName);
                    Property property = document.getProperty(field.getName().getPrefixedName());
                    List<ConstraintViolation.PathNode> path = Arrays.asList(new ConstraintViolation.PathNode(property.getField()));
                    violations.addAll(this.validateAnyTypeProperty(property.getSchema(), path, property));
                }
            }
        } else {
            for (Schema schema : docType.getSchemas()) {
                for (Field field : schema.getFields()) {
                    Property property = document.getProperty(field.getName().getPrefixedName());
                    List<ConstraintViolation.PathNode> path = Arrays.asList(new ConstraintViolation.PathNode(property.getField()));
                    violations.addAll(this.validateAnyTypeProperty(property.getSchema(), path, property));
                }
            }
        }
        return new DocumentValidationReport(violations);
    }

    @Override
    public DocumentValidationReport validate(Field field, Object value) {
        String prefix = field.getName().getPrefix();
        Schema schema = this.getSchemaManager().getSchemaFromPrefix(prefix);
        return new DocumentValidationReport(this.validate(schema, field, value));
    }

    @Override
    public DocumentValidationReport validate(Property property) {
        List<ConstraintViolation.PathNode> path = Arrays.asList(new ConstraintViolation.PathNode(property.getField()));
        return new DocumentValidationReport(this.validateAnyTypeProperty(property.getSchema(), path, property));
    }

    @Override
    public DocumentValidationReport validate(String xpath, Object value) throws IllegalArgumentException {
        String[] splitted = xpath.split(":|/");
        if (splitted.length < 2) {
            throw new IllegalArgumentException("Invalid xpath " + xpath);
        }
        Schema schemaDef = this.getSchemaManager().getSchemaFromPrefix(splitted[0]);
        if (schemaDef == null) {
            throw new IllegalArgumentException("Invalid xpath " + xpath);
        }
        Field field = schemaDef.getField(splitted[1]);
        if (field == null) {
            throw new IllegalArgumentException("Invalid xpath " + xpath);
        }
        for (int i = 2; i < splitted.length; ++i) {
            ComplexType complexType;
            if (field.getType().isListType()) {
                ListType listType = (ListType)field.getType();
                if (!splitted[i].equals(listType.getFieldName())) {
                    throw new IllegalArgumentException("Invalid xpath " + xpath);
                }
                field = listType.getField();
                continue;
            }
            if (!field.getType().isComplexType() || (field = (complexType = (ComplexType)field.getType()).getField(splitted[i])) != null) continue;
            throw new IllegalArgumentException("Invalid xpath " + xpath);
        }
        return new DocumentValidationReport(this.validate(schemaDef, field, value));
    }

    protected List<ConstraintViolation> validate(Schema schema, Field field, Object value) {
        List<ConstraintViolation.PathNode> path = Arrays.asList(new ConstraintViolation.PathNode(field));
        return this.validateAnyTypeField(schema, path, field, value);
    }

    private List<ConstraintViolation> validateAnyTypeField(Schema schema, List<ConstraintViolation.PathNode> path, Field field, Object value) {
        if (field.getType().isSimpleType()) {
            return this.validateSimpleTypeField(schema, path, field, value);
        }
        if (field.getType().isComplexType()) {
            return this.validateComplexTypeField(schema, path, field, value);
        }
        if (field.getType().isListType()) {
            return this.validateListTypeField(schema, path, field, value);
        }
        return Collections.emptyList();
    }

    private List<ConstraintViolation> validateSimpleTypeField(Schema schema, List<ConstraintViolation.PathNode> path, Field field, Object value) {
        assert (field.getType().isSimpleType() || field.getType().isListType());
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        for (Constraint constraint : field.getConstraints()) {
            if (constraint.validate(value)) continue;
            ConstraintViolation violation = new ConstraintViolation(schema, path, constraint, value);
            violations.add(violation);
        }
        return violations;
    }

    private List<ConstraintViolation> validateComplexTypeField(Schema schema, List<ConstraintViolation.PathNode> path, Field field, Object value) {
        assert (field.getType().isComplexType());
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        ComplexType complexType = (ComplexType)field.getType();
        if (value != null && !(value instanceof Map)) {
            return violations;
        }
        Map map = (Map)value;
        if (value == null || map.isEmpty()) {
            if (!field.isNillable()) {
                this.addNotNullViolation(violations, schema, path);
            }
        } else {
            for (Field child : complexType.getFields()) {
                Object item = map.get(child.getName().getLocalName());
                ArrayList<ConstraintViolation.PathNode> subPath = new ArrayList<ConstraintViolation.PathNode>(path);
                subPath.add(new ConstraintViolation.PathNode(child));
                violations.addAll(this.validateAnyTypeField(schema, subPath, child, item));
            }
        }
        return violations;
    }

    private List<ConstraintViolation> validateListTypeField(Schema schema, List<ConstraintViolation.PathNode> path, Field field, Object value) {
        assert (field.getType().isListType());
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        List<Object> castedValue = null;
        if (value instanceof List) {
            castedValue = (List<Object>)value;
        } else if (value instanceof Object[]) {
            castedValue = Arrays.asList((Object[])value);
        }
        if (castedValue != null) {
            ListType listType = (ListType)field.getType();
            Field listField = listType.getField();
            int index = 0;
            for (Object e : castedValue) {
                ArrayList<ConstraintViolation.PathNode> subPath = new ArrayList<ConstraintViolation.PathNode>(path);
                subPath.add(new ConstraintViolation.PathNode(listField, index));
                violations.addAll(this.validateAnyTypeField(schema, subPath, listField, e));
                ++index;
            }
            return violations;
        }
        return violations;
    }

    private List<ConstraintViolation> validateAnyTypeProperty(Schema schema, List<ConstraintViolation.PathNode> path, Property prop) {
        Field field = prop.getField();
        if (field.getType().isSimpleType()) {
            return this.validateSimpleTypeProperty(schema, path, prop);
        }
        if (field.getType().isComplexType()) {
            return this.validateComplexTypeProperty(schema, path, prop);
        }
        if (field.getType().isListType()) {
            return this.validateListTypeProperty(schema, path, prop);
        }
        return Collections.emptyList();
    }

    private List<ConstraintViolation> validateSimpleTypeProperty(Schema schema, List<ConstraintViolation.PathNode> path, Property prop) {
        Field field = prop.getField();
        assert (field.getType().isSimpleType() || prop.isScalar());
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        Serializable value = prop.getValue();
        if (prop.isPhantom() || value == null) {
            if (!field.isNillable()) {
                this.addNotNullViolation(violations, schema, path);
            }
        } else {
            violations.addAll(this.validateSimpleTypeField(schema, path, field, value));
        }
        return violations;
    }

    private List<ConstraintViolation> validateComplexTypeProperty(Schema schema, List<ConstraintViolation.PathNode> path, Property prop) {
        Field field = prop.getField();
        assert (field.getType().isComplexType());
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        boolean allChildrenPhantom = true;
        for (Property child : prop.getChildren()) {
            if (child.isPhantom()) continue;
            allChildrenPhantom = false;
            break;
        }
        Serializable value = prop.getValue();
        if (prop.isPhantom() || value == null || allChildrenPhantom) {
            if (!field.isNillable()) {
                this.addNotNullViolation(violations, schema, path);
            }
        } else if (value instanceof Map) {
            Map castedValue = (Map)((Object)value);
            if (value == null || castedValue.isEmpty()) {
                if (!field.isNillable()) {
                    this.addNotNullViolation(violations, schema, path);
                }
            } else {
                for (Property child : prop.getChildren()) {
                    ArrayList<ConstraintViolation.PathNode> subPath = new ArrayList<ConstraintViolation.PathNode>(path);
                    subPath.add(new ConstraintViolation.PathNode(child.getField()));
                    violations.addAll(this.validateAnyTypeProperty(schema, subPath, child));
                }
            }
        }
        return violations;
    }

    private List<ConstraintViolation> validateListTypeProperty(Schema schema, List<ConstraintViolation.PathNode> path, Property prop) {
        ArrayList<ConstraintViolation> violations;
        block10: {
            Serializable value;
            Field field;
            block9: {
                field = prop.getField();
                assert (field.getType().isListType());
                violations = new ArrayList<ConstraintViolation>();
                value = prop.getValue();
                if (!prop.isPhantom() && value != null) break block9;
                if (field.isNillable()) break block10;
                this.addNotNullViolation(violations, schema, path);
                break block10;
            }
            List<Object> castedValue = null;
            if (value instanceof Collection) {
                castedValue = (List<Object>)((Object)value);
            } else if (value instanceof Object[]) {
                castedValue = Arrays.asList((Object[])value);
            }
            if (castedValue != null) {
                int index = 0;
                if (prop instanceof ArrayProperty) {
                    for (Object e : castedValue) {
                        ArrayList<ConstraintViolation.PathNode> subPath = new ArrayList<ConstraintViolation.PathNode>(path);
                        subPath.add(new ConstraintViolation.PathNode(field, index));
                        violations.addAll(this.validateSimpleTypeField(schema, subPath, field, e));
                        ++index;
                    }
                } else {
                    for (Property property : prop.getChildren()) {
                        ArrayList<ConstraintViolation.PathNode> subPath = new ArrayList<ConstraintViolation.PathNode>(path);
                        subPath.add(new ConstraintViolation.PathNode(property.getField(), index));
                        violations.addAll(this.validateAnyTypeProperty(schema, subPath, property));
                        ++index;
                    }
                }
            }
        }
        return violations;
    }

    private void addNotNullViolation(List<ConstraintViolation> violations, Schema schema, List<ConstraintViolation.PathNode> fieldPath) {
        NotNullConstraint constraint = NotNullConstraint.get();
        ConstraintViolation violation = new ConstraintViolation(schema, fieldPath, (Constraint)constraint, null);
        violations.add(violation);
    }
}

