/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.DefaultMBeanInterceptor;
import com.sun.jdmk.MBeanInstantiator;
import com.sun.jdmk.MBeanInterceptor;
import com.sun.jdmk.MBeanServerDelegateImpl;
import com.sun.jdmk.MBeanServerInt;
import com.sun.jdmk.MetaData;
import com.sun.jdmk.MetaDataImpl;
import com.sun.jdmk.ModifiableClassLoaderRepository;
import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.interceptor.MBeanServerInterceptor;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public class MBeanServerImpl
implements MBeanServer,
MBeanServerInt {
    private transient MBeanInterceptor interceptor = null;
    private final String dbgTag = "MBeanServer";
    private MBeanInstantiator instantiator = null;
    private MetaData meta = null;
    private transient MBeanServerDelegate MBeanServerDelegateObject = null;
    private transient ObjectName MBeanServerDelegateObjectName = null;
    private transient SecureClassLoaderRepository secureClr = null;

    public MBeanServerImpl(MBeanInstantiator instantiator) {
        this(instantiator, null);
    }

    public MBeanServerImpl(MBeanInstantiator instantiator, String domain) {
        this(instantiator, null, domain);
    }

    public MBeanServerImpl(MBeanInstantiator instantiator, MetaData metadata, String domain) {
        this.initialize(instantiator, metadata, domain);
    }

    @Override
    public MBeanInstantiator getMBeanInstantiator() {
        return this.instantiator;
    }

    @Override
    public MetaData getMetaData() {
        return this.meta;
    }

    @Override
    public synchronized MBeanInterceptor getDefaultMBeanInterceptor() {
        return this.interceptor;
    }

    @Override
    public synchronized void setDefaultMBeanInterceptor(MBeanInterceptor mbi) throws IllegalArgumentException {
        if (mbi == null) {
            throw new IllegalArgumentException("Null MBeanInterceptor");
        }
        this.interceptor = mbi;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.interceptor.createMBean(className, name, null, null);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.interceptor.createMBean(className, name, loaderName, null, null);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.interceptor.createMBean(className, name, params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.interceptor.createMBean(className, name, loaderName, params, signature);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.interceptor.registerMBean(object, name);
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.interceptor.unregisterMBean(name);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.interceptor.getObjectInstance(name);
    }

    @Override
    public Set queryMBeans(ObjectName name, QueryExp query) {
        return this.interceptor.queryMBeans(name, query);
    }

    @Override
    public Set queryNames(ObjectName name, QueryExp query) {
        return this.interceptor.queryNames(name, query);
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        return this.interceptor.isRegistered(name);
    }

    @Override
    public Integer getMBeanCount() {
        return this.interceptor.getMBeanCount();
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.interceptor.getAttribute(name, attribute);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.interceptor.getAttributes(name, attributes);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.interceptor.setAttribute(name, attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.interceptor.setAttributes(name, attributes);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.interceptor.invoke(name, operationName, params, signature);
    }

    @Override
    public String getDefaultDomain() {
        return this.interceptor.getDefaultDomain();
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.interceptor.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.interceptor.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.interceptor.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.interceptor.removeNotificationListener(name, listener);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.interceptor.getMBeanInfo(name);
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.instantiator.instantiate(className);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiator.instantiate(className, loaderName, this.getClass().getClassLoader());
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.instantiator.instantiate(className, params, signature, this.getClass().getClassLoader());
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiator.instantiate(className, loaderName, params, signature, this.getClass().getClassLoader());
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.interceptor.isInstanceOf(name, className);
    }

    @Override
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        return this.instantiator.deserialize(name, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return this.instantiator.deserialize(className, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.instantiator.deserialize(className, loaderName, data, this.getClass().getClassLoader());
    }

    @Override
    public ClassLoader getMBeanClassLoader(ObjectName name) throws InstanceNotFoundException {
        return this.interceptor.getMBeanClassLoader(name);
    }

    private void initialize(MBeanInstantiator instantiator, MetaData meta, String domain) {
        this.instantiator = instantiator;
        if (instantiator == null) {
            throw new IllegalArgumentException("instantiator must not be null.");
        }
        this.meta = meta == null ? new MetaDataImpl(instantiator) : meta;
        this.secureClr = new SecureClassLoaderRepository(instantiator.getClassLoaderRepository());
        this.interceptor = domain != null ? new DefaultMBeanInterceptor(this, domain) : new DefaultMBeanInterceptor(this);
        try {
            this.MBeanServerDelegateObject = new MBeanServerDelegateImpl(new MBeanServerDelegate());
            this.MBeanServerDelegateObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            this.interceptor.registerMBean(this.MBeanServerDelegateObject, this.MBeanServerDelegateObjectName);
        }
        catch (JMException e) {
            RuntimeException r = new RuntimeException("Unexpected JMException: " + e);
            Utils.initCause(r, e);
            throw r;
        }
        ClassLoader myLoader = this.getClass().getClassLoader();
        ModifiableClassLoaderRepository loaders = instantiator.getClassLoaderRepository();
        if (loaders != null && myLoader != null) {
            loaders.addClassLoader(myLoader);
        }
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return this.secureClr;
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.interceptor.getMBeanClassLoader(mbeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        ClassLoader loader;
        if (this.interceptor instanceof MBeanServerInterceptor) {
            return ((MBeanServerInterceptor)this.interceptor).getClassLoader(loaderName);
        }
        ModifiableClassLoaderRepository loaders = this.instantiator.getClassLoaderRepository();
        MBeanInstantiator mBeanInstantiator = this.instantiator;
        synchronized (mBeanInstantiator) {
            loader = loaders.getClassLoader(loaderName);
        }
        if (loader == null) {
            throw new InstanceNotFoundException("The loader named " + loaderName + " is not registered in the MBeanServer");
        }
        return loader;
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.interceptor instanceof MBeanServerInterceptor) {
            ((MBeanServerInterceptor)this.interceptor).removeNotificationListener(name, listener, filter, handback);
            return;
        }
        String unsupported = "Operation not supported in this implementation";
        throw new UnsupportedOperationException("Operation not supported in this implementation");
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listenerName, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.interceptor instanceof MBeanServerInterceptor) {
            ((MBeanServerInterceptor)this.interceptor).removeNotificationListener(name, listenerName, filter, handback);
            return;
        }
        String unsupported = "Operation not supported in this implementation";
        throw new UnsupportedOperationException("Operation not supported in this implementation");
    }

    @Override
    public String[] getDomains() {
        if (this.interceptor instanceof MBeanServerInterceptor) {
            return ((MBeanServerInterceptor)this.interceptor).getDomains();
        }
        Set names = this.interceptor.queryNames(null, null);
        HashSet<String> tmpSet = new HashSet<String>(1);
        for (ObjectName x : names) {
            String domain = x.getDomain();
            if (tmpSet.contains(domain)) continue;
            tmpSet.add(domain);
        }
        String[] result = new String[tmpSet.size()];
        return tmpSet.toArray(result);
    }

    @Override
    public MBeanServerDelegate getMBeanServerDelegate() {
        return this.MBeanServerDelegateObject;
    }

    static final class SecureClassLoaderRepository
    implements ClassLoaderRepository {
        private final ClassLoaderRepository clr;

        public SecureClassLoaderRepository(ClassLoaderRepository clr) {
            this.clr = clr;
        }

        public final Class loadClass(String className) throws ClassNotFoundException {
            return this.clr.loadClass(className);
        }

        public final Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
            return this.clr.loadClassWithout(loader, className);
        }

        public final Class loadClassBefore(ClassLoader loader, String className) throws ClassNotFoundException {
            return this.clr.loadClassBefore(loader, className);
        }
    }
}

