/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ActionFilter;
import org.nuxeo.ecm.platform.actions.FilterRule;

@XObject(value="filter")
public class DefaultActionFilter
implements ActionFilter,
Cloneable {
    private static final long serialVersionUID = 8885038533939001747L;
    private static final Log log = LogFactory.getLog(DefaultActionFilter.class);
    @XNode(value="@id")
    protected String id;
    @XNode(value="@append")
    protected boolean append;
    @XNodeList(value="rule", type=String[].class, componentType=FilterRule.class)
    protected FilterRule[] rules;
    public static final String PRECOMPUTED_KEY = "PrecomputedFilters";

    public DefaultActionFilter() {
        this(null, null, false);
    }

    public DefaultActionFilter(String id, FilterRule[] rules) {
        this(id, rules, false);
    }

    public DefaultActionFilter(String id, FilterRule[] rules, boolean append) {
        this.id = id;
        this.rules = rules;
        this.append = append;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public FilterRule[] getRules() {
        return this.rules;
    }

    public void setRules(FilterRule[] rules) {
        this.rules = rules;
    }

    @Override
    public boolean accept(Action action, ActionContext context) {
        if (log.isDebugEnabled()) {
            if (action == null) {
                log.debug((Object)String.format("#accept: checking filter '%s'", this.getId()));
            } else {
                log.debug((Object)String.format("#accept: checking filter '%s' for action '%s'", this.getId(), action.getId()));
            }
        }
        if (context == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"#accept: no context available: action filtered");
            }
            return false;
        }
        if (this.rules == null || this.rules.length == 0) {
            return true;
        }
        boolean existsGrantRule = false;
        boolean grantApply = false;
        for (FilterRule rule : this.rules) {
            boolean ruleApplies = this.checkRule(rule, context);
            if (!rule.grant) {
                if (!ruleApplies) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"#accept: denying rule applies => action filtered");
                }
                return false;
            }
            existsGrantRule = true;
            if (!ruleApplies) continue;
            grantApply = true;
        }
        if (existsGrantRule) {
            if (log.isDebugEnabled()) {
                if (grantApply) {
                    log.debug((Object)"#accept: granting rule applies, action not filtered");
                } else {
                    log.debug((Object)"#accept: granting rule applies, action filtered");
                }
            }
            return grantApply;
        }
        return true;
    }

    protected final boolean checkRule(FilterRule rule, ActionContext context) {
        boolean result;
        Map precomputed;
        boolean disableCache;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("#checkRule: checking rule '%s'", rule));
        }
        if (!(disableCache = context.disableGlobalCaching()) && (precomputed = (Map)context.getLocalVariable(PRECOMPUTED_KEY)) != null && precomputed.containsKey(rule)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("#checkRule: return precomputed result for rule '%s'", rule));
            }
            return Boolean.TRUE.equals(precomputed.get(rule));
        }
        boolean bl = result = !(rule.facets != null && rule.facets.length != 0 && !this.checkFacets(context, rule.facets) || rule.types != null && rule.types.length != 0 && !this.checkTypes(context, rule.types) || rule.schemas != null && rule.schemas.length != 0 && !this.checkSchemas(context, rule.schemas) || rule.permissions != null && rule.permissions.length != 0 && !this.checkPermissions(context, rule.permissions) || rule.groups != null && rule.groups.length != 0 && !this.checkGroups(context, rule.groups) || rule.conditions != null && rule.conditions.length != 0 && !this.checkConditions(context, rule.conditions));
        if (!disableCache) {
            HashMap<FilterRule, Boolean> precomputed2 = (HashMap<FilterRule, Boolean>)context.getLocalVariable(PRECOMPUTED_KEY);
            if (precomputed2 == null) {
                precomputed2 = new HashMap<FilterRule, Boolean>();
                context.putLocalVariable(PRECOMPUTED_KEY, precomputed2);
            }
            precomputed2.put(rule, result);
        }
        return result;
    }

    protected final boolean checkFacets(ActionContext context, String[] facets) {
        DocumentModel doc = context.getCurrentDocument();
        if (doc == null) {
            return false;
        }
        for (String facet : facets) {
            if (!doc.hasFacet(facet)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("#checkFacets: return true for facet '%s'", facet));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"#checkFacets: return false");
        }
        return false;
    }

    protected final boolean checkPermissions(ActionContext context, String[] permissions) {
        DocumentModel doc = context.getCurrentDocument();
        if (doc == null) {
            NuxeoPrincipal principal = context.getCurrentPrincipal();
            if (principal != null && principal.isAdministrator()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"#checkPermissions: doc is null but user is admin => return true");
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"#checkPermissions: doc and user are null => return false");
            }
            return false;
        }
        CoreSession docMgr = context.getDocumentManager();
        if (docMgr == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"#checkPermissions: no core session => return false");
            }
            return false;
        }
        for (String permission : permissions) {
            try {
                if (!docMgr.hasPermission(doc.getRef(), permission)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("#checkPermissions: return true for permission '%s'", permission));
                }
                return true;
            }
            catch (ClientException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"#checkPermissions: return false");
        }
        return false;
    }

    protected final boolean checkGroups(ActionContext context, String[] groups) {
        NuxeoPrincipal principal = context.getCurrentPrincipal();
        if (principal == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"#checkGroups: no user => return false");
            }
            return false;
        }
        for (String group : groups) {
            if (!principal.isMemberOf(group)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("#checkGroups: return true for group '%s'", group));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"#checkGroups: return false");
        }
        return false;
    }

    protected final boolean checkConditions(ActionContext context, String[] conditions) {
        for (String condition : conditions) {
            try {
                if (!context.checkCondition(condition)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("#checkCondition: return true for condition '%s'", condition));
                }
                return true;
            }
            catch (ELException e) {
                log.error((Object)("evaluation of condition " + condition + " failed: returning false"), (Throwable)e);
                return false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"#checkConditions: return false");
        }
        return false;
    }

    protected final boolean checkTypes(ActionContext context, String[] types) {
        DocumentModel doc = context.getCurrentDocument();
        String docType = doc == null ? "Root" : doc.getType();
        for (String type : types) {
            if (!type.equals(docType)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("#checkTypes: return true for type '%s'", docType));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"#checkTypes: return false");
        }
        return false;
    }

    protected final boolean checkSchemas(ActionContext context, String[] schemas) {
        DocumentModel doc = context.getCurrentDocument();
        if (doc == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"#checkSchemas: no doc => return false");
            }
            return false;
        }
        for (String schema : schemas) {
            if (!doc.hasSchema(schema)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("#checkSchemas: return true for schema '%s'", schema));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"#checkSchemas: return false");
        }
        return false;
    }

    public boolean getAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    public DefaultActionFilter clone() {
        DefaultActionFilter clone = new DefaultActionFilter();
        clone.id = this.id;
        clone.append = this.append;
        if (this.rules != null) {
            clone.rules = new FilterRule[this.rules.length];
            for (int i = 0; i < this.rules.length; ++i) {
                clone.rules[i] = this.rules[i].clone();
            }
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultActionFilter)) {
            return false;
        }
        DefaultActionFilter o = (DefaultActionFilter)obj;
        String objId = o.getId();
        if (objId == null && this.id != null) {
            return false;
        }
        if (this.id == null && objId != null) {
            return false;
        }
        if (objId != null && !objId.equals(this.id)) {
            return false;
        }
        boolean append = o.getAppend();
        if (!append == this.append) {
            return false;
        }
        FilterRule[] objRules = o.getRules();
        if (objRules == null && this.rules != null) {
            return false;
        }
        if (this.rules == null && objRules != null) {
            return false;
        }
        if (objRules != null) {
            if (objRules.length != this.rules.length) {
                return false;
            }
            for (int i = 0; i < objRules.length; ++i) {
                if (objRules[i] == null && this.rules[i] != null) {
                    return false;
                }
                if (this.rules[i] == null && objRules[i] != null) {
                    return false;
                }
                if (objRules[i].equals(this.rules[i])) continue;
                return false;
            }
        }
        return true;
    }
}

