/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.fm;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluggableTemplareLoader
implements TemplateLoader {
    private static final Log log = LogFactory.getLog(PluggableTemplareLoader.class);
    protected ClassTemplateLoader defaultLoader;
    protected ClassTemplateLoader additionnalLoader;

    public PluggableTemplareLoader(ClassTemplateLoader defaultLoader) {
        this.defaultLoader = defaultLoader;
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        this.defaultLoader.closeTemplateSource(templateSource);
    }

    public Object findTemplateSource(String name) throws IOException {
        Object template = null;
        if (this.additionnalLoader != null) {
            try {
                template = this.additionnalLoader.findTemplateSource(name);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if (template == null) {
            template = this.defaultLoader.findTemplateSource(name);
        }
        return template;
    }

    public long getLastModified(Object templateSource) {
        return this.defaultLoader.getLastModified(templateSource);
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return this.defaultLoader.getReader(templateSource, encoding);
    }

    public TemplateLoader getAdditionnalLoader() {
        return this.additionnalLoader;
    }

    public void setAdditionnalLoader(ClassTemplateLoader additionnalLoader) {
        this.additionnalLoader = additionnalLoader;
    }
}

