/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.fprpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.wss.fprpc.CAMLHandler;
import org.nuxeo.wss.fprpc.FPRPCCall;
import org.nuxeo.wss.fprpc.FPRPCConts;
import org.nuxeo.wss.fprpc.exceptions.MalformedFPRPCRequest;
import org.nuxeo.wss.servlet.WSSRequest;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class FPRPCRequest
extends WSSRequest {
    private String windowsEncoding = System.getProperty("org.nuxeo.wss.handler.windows.encoding");
    public static final int FPRPC_GET_REQUEST = 0;
    public static final int FPRPC_POST_REQUEST = 1;
    public static final int FPRPC_CAML_REQUEST = 2;
    protected String version;
    protected List<FPRPCCall> calls;
    protected int requestMode = 0;
    protected InputStream vermeerBinary = null;
    protected Principal principal;

    public FPRPCRequest(HttpServletRequest httpRequest, String sitePath) throws MalformedFPRPCRequest {
        super(httpRequest, sitePath);
        this.parseRequest();
    }

    protected void parseRequest() throws MalformedFPRPCRequest {
        this.principal = this.httpRequest.getUserPrincipal();
        if ("GET".equals(this.httpRequest.getMethod()) || "HEAD".equals(this.httpRequest.getMethod())) {
            this.requestMode = 0;
            this.parseGETRequest();
        } else if ("POST".equals(this.httpRequest.getMethod())) {
            String ct = this.httpRequest.getHeader(FPRPCConts.FP_CONTENT_TYPE_HEADER);
            if (FPRPCConts.FORM_ENCODED_CONTENT_TYPE.equals(ct)) {
                this.requestMode = 1;
                this.parsePOSTRequest();
            } else if (FPRPCConts.VERMEER_ENCODED_CONTENT_TYPE.equals(ct)) {
                this.requestMode = 1;
                this.parsePOSTRequest();
            } else {
                this.requestMode = 2;
                this.parseCAMLRequest();
            }
        } else {
            throw new MalformedFPRPCRequest(this.httpRequest.getMethod() + " is not supported");
        }
    }

    protected void parseGETRequest() throws MalformedFPRPCRequest {
        this.parseSimpleParameters(FPRPCConts.CMD_PARAM);
    }

    protected void parsePOSTRequest() throws MalformedFPRPCRequest {
        this.parseSimpleParameters(FPRPCConts.METHOD_PARAM);
    }

    protected Map<String, String> extractVermeerEncodedParameters(HttpServletRequest httpRequest) throws IOException {
        String[] parts;
        HashMap<String, String> parameters = new HashMap<String, String>();
        ServletInputStream input = httpRequest.getInputStream();
        int byt = input.read();
        boolean beginBinary = false;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int idx = 0;
        while (byt > 0 && !beginBinary) {
            buffer.write(byt);
            if (byt == 10) {
                beginBinary = true;
            } else {
                byt = input.read();
            }
            ++idx;
        }
        String paramData = buffer.toString("utf-8");
        paramData = URLDecoder.decode(paramData, "utf-8");
        for (String part : parts = paramData.split("\\&")) {
            int idx2 = part.indexOf("=");
            if (idx2 <= 0) continue;
            String k = part.substring(0, idx2).trim();
            String v = part.substring(idx2 + 1).trim();
            if (v.startsWith("[")) {
                Map<String, String> uParams = this.unpackParameters(v);
                for (String sk : uParams.keySet()) {
                    parameters.put(k + "/" + sk, uParams.get(sk));
                }
                continue;
            }
            parameters.put(k, v);
        }
        this.vermeerBinary = input;
        return parameters;
    }

    protected Map<String, String> unpackParameters(String packedParams) {
        String[] parts;
        HashMap<String, String> params = new HashMap<String, String>();
        packedParams = packedParams.substring(1, packedParams.length() - 1);
        for (String part : parts = packedParams.split("\\;")) {
            String[] p = part.split("=");
            if (p.length == 2) {
                params.put(p[0].trim(), p[1].trim());
                continue;
            }
            params.put(p[0].trim(), "");
        }
        return params;
    }

    protected Map<String, String> extractUrlEncodedParameters(HttpServletRequest httpRequest) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Enumeration pNames = httpRequest.getParameterNames();
        while (pNames.hasMoreElements()) {
            String key = ((String)pNames.nextElement()).trim();
            String value = httpRequest.getParameter(key).trim();
            value = this.decodeParameterValue(value);
            parameters.put(key, value);
        }
        return parameters;
    }

    protected void parseSimpleParameters(String cmdName) throws MalformedFPRPCRequest {
        Map<String, String> parameters;
        if (FPRPCConts.VERMEER_ENCODED_CONTENT_TYPE.equals(this.httpRequest.getContentType())) {
            try {
                parameters = this.extractVermeerEncodedParameters(this.httpRequest);
            }
            catch (IOException e) {
                throw new MalformedFPRPCRequest("Error in Vermeer encoding parsing", e);
            }
        } else {
            parameters = this.extractUrlEncodedParameters(this.httpRequest);
        }
        String cmd = parameters.get(cmdName);
        if (cmd == null && (cmd = parameters.get("dialogview")) == null) {
            throw new MalformedFPRPCRequest("No Cmd parameter was found");
        }
        if ((cmd = cmd.replace("\n", "")).contains(":")) {
            String[] parts = cmd.split("\\:");
            cmd = parts[0];
            this.version = parts[1];
        }
        parameters.remove(cmdName);
        FPRPCCall call = new FPRPCCall(cmd, parameters);
        this.calls = new ArrayList<FPRPCCall>();
        this.calls.add(call);
    }

    protected void parseCAMLRequest() throws MalformedFPRPCRequest {
        try {
            XMLReader reader = CAMLHandler.getXMLReader();
            reader.parse(new InputSource((InputStream)this.httpRequest.getInputStream()));
            this.calls = ((CAMLHandler)reader.getContentHandler()).getParsedCalls();
        }
        catch (IOException | SAXException e) {
            throw new MalformedFPRPCRequest("Unable to parse CAML Request");
        }
    }

    public List<FPRPCCall> getCalls() {
        return this.calls;
    }

    public int getRequestMode() {
        return this.requestMode;
    }

    public String getVersion() {
        return this.version;
    }

    public InputStream getVermeerBinary() {
        return this.vermeerBinary;
    }

    public String getPrincipalName() {
        return this.principal != null ? this.principal.getName() : "anonymous";
    }

    @Override
    public String getBaseUrl(String fpDir) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getBaseUrl(fpDir));
        if (fpDir != null) {
            String sp = this.getSitePath();
            if (sp.startsWith("/")) {
                sp = sp.substring(1);
            }
            if (sp.endsWith("/")) {
                sp = sp.substring(0, sp.length() - 1);
            }
            if ("catalogs".equals(fpDir)) {
                if (!"".equals(sp)) {
                    sb.append(sp).append('/');
                }
                sb.append("_catalogs/");
            } else if ("layouts".equals(fpDir)) {
                if (!"".equals(sp)) {
                    sb.append(sp).append('/');
                }
                sb.append("_layouts/");
            }
        }
        return sb.toString();
    }

    protected String decodeParameterValue(String path) {
        String encoding = this.windowsEncoding;
        if (StringUtils.isEmpty((String)encoding)) {
            encoding = "ISO-8859-1";
        }
        try {
            path = new String(path.getBytes(encoding), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return path;
    }
}

