/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.handlers.fprpc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.CallRouter;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.fprpc.FPRPCRequest;
import org.nuxeo.wss.fprpc.FPRPCResponse;
import org.nuxeo.wss.handlers.fprpc.FPRPCHandler;
import org.nuxeo.wss.servlet.config.FilterBindingConfig;

public class FPRPCRouter
extends CallRouter {
    private static final Log log = LogFactory.getLog(FPRPCRouter.class);

    public static void handleFPRCPRequest(FPRPCRequest fpRequest, FPRPCResponse fpResponse, FilterBindingConfig config) throws WSSException {
        FPRPCHandler handler = FPRPCRouter.getHandler(FPRPCHandler.class, config.getTargetService());
        if (handler == null) {
            log.error((Object)("Can not find handler for service " + config.getTargetService()));
            throw new WSSException("No handler found for " + config.getTargetService());
        }
        log.debug((Object)("Handle FPRPC request with handler" + handler.getClass().getSimpleName()));
        handler.handleRequest(fpRequest, fpResponse);
    }
}

