/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;

public class IWork2PDFConverter
implements Converter {
    public static final List<String> IWORK_MIME_TYPES = Arrays.asList("application/vnd.apple.pages", "application/vnd.apple.keynote", "application/vnd.apple.numbers", "application/vnd.apple.iwork");
    private static final String IWORK_PREVIEW_FILE = "QuickLook/Preview.pdf";

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        try {
            Blob blob = blobHolder.getBlob();
            String mimeType = blob.getMimeType();
            if (mimeType == null || !IWORK_MIME_TYPES.contains(mimeType)) {
                throw new ConversionException("not an iWork file");
            }
            if (ZipUtils.hasEntry((InputStream)blob.getStream(), (String)IWORK_PREVIEW_FILE)) {
                InputStream previewPDFFile = ZipUtils.getEntryContentAsStream((InputStream)blob.getStream(), (String)IWORK_PREVIEW_FILE);
                FileBlob previewBlob = new FileBlob(previewPDFFile);
                return new SimpleCachableBlobHolder((Blob)previewBlob);
            }
            throw new ConversionException("iWork file does not contain a pdf preview.");
        }
        catch (IOException e) {
            throw new ConversionException("Could not find the pdf preview in the iWork file", (Exception)e);
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

