/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.web.admin;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.web.admin.PageProviderStatus;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;

@Name(value="esAdmin")
@Scope(value=ScopeType.EVENT)
public class ElasticSearchManager {
    private static final Log log = LogFactory.getLog(ElasticSearchManager.class);
    private static final String DEFAULT_NXQL_QUERY = "SELECT * FROM Document";
    private static final String JSON_DELETE_CMD = "{\"id\":\"IndexingCommand-reindex\",\"name\":\"ES_DELETE\",\"docId\":\"%s\",\"repo\":\"%s\",\"recurse\":true,\"sync\":true}";
    @In(create=true)
    protected ElasticSearchAdmin esa;
    @In(create=true)
    protected ElasticSearchIndexing esi;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    protected List<PageProviderStatus> ppStatuses = null;
    protected Timer indexTimer;
    protected Timer bulkIndexTimer;
    private String rootId;
    private String nxql = "SELECT * FROM Document";
    private String repositoryName;
    private Boolean dropIndex = false;

    public String getNodesInfo() {
        NodesInfoResponse nodesInfo = (NodesInfoResponse)this.esa.getClient().admin().cluster().prepareNodesInfo(new String[0]).execute().actionGet();
        return nodesInfo.toString();
    }

    public String getNodesStats() {
        NodesStatsResponse stats = (NodesStatsResponse)this.esa.getClient().admin().cluster().prepareNodesStats(new String[0]).execute().actionGet();
        return stats.toString();
    }

    public String getNodesHealth() {
        ClusterHealthResponse health = (ClusterHealthResponse)this.esa.getClient().admin().cluster().prepareHealth(new String[0]).execute().actionGet();
        return health.toString();
    }

    public void startReindexAll() {
        log.warn((Object)("Re-indexing the entire repository: " + this.repositoryName));
        this.esa.dropAndInitRepositoryIndex(this.repositoryName);
        this.esi.reindex(this.repositoryName, "SELECT ecm:uuid FROM Document");
    }

    public void startReindexNxql() {
        log.warn((Object)String.format("Re-indexing from a NXQL query: %s on repository: %s", this.getNxql(), this.repositoryName));
        this.esi.reindex(this.repositoryName, this.getNxql());
    }

    public void startReindexFrom() {
        try (CoreSession session = CoreInstance.openCoreSessionSystem((String)this.repositoryName);){
            log.warn((Object)String.format("Try to remove %s and its children from %s repository index", this.rootId, this.repositoryName));
            String jsonCmd = String.format(JSON_DELETE_CMD, this.rootId, this.repositoryName);
            IndexingCommand rmCmd = IndexingCommand.fromJSON((CoreSession)session, (String)jsonCmd);
            this.esi.indexNow(rmCmd);
            IdRef ref = new IdRef(this.rootId);
            if (session.exists((DocumentRef)ref)) {
                DocumentModel doc = session.getDocument((DocumentRef)ref);
                log.warn((Object)String.format("Re-indexing document: %s and its children on repository: %s", doc, this.repositoryName));
                IndexingCommand cmd = new IndexingCommand(doc, false, true);
                this.esi.scheduleIndexing(cmd);
            }
        }
    }

    public void flush() {
        this.esa.flush();
    }

    protected void introspectPageProviders() {
        this.ppStatuses = new ArrayList<PageProviderStatus>();
        PageProviderService pps = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        for (String ppName : pps.getPageProviderDefinitionNames()) {
            PageProviderDefinition def = pps.getPageProviderDefinition(ppName);
            PageProvider pp = pps.getPageProvider(ppName, def, null, null, Long.valueOf(0L), Long.valueOf(0L), null, new Object[0]);
            String klass = pp.getClass().getCanonicalName();
            this.ppStatuses.add(new PageProviderStatus(ppName, klass));
        }
        Collections.sort(this.ppStatuses);
    }

    public List<PageProviderStatus> getContentViewStatus() {
        if (this.ppStatuses == null) {
            this.introspectPageProviders();
        }
        return this.ppStatuses;
    }

    public Boolean isIndexingInProgress() {
        return this.esa.isIndexingInProgress();
    }

    public String getPendingCommands() {
        return Integer.valueOf(this.esa.getPendingCommands()).toString();
    }

    public String getRunningCommands() {
        return Integer.valueOf(this.esa.getRunningCommands()).toString();
    }

    public String getTotalCommandProcessed() {
        return Integer.valueOf(this.esa.getTotalCommandProcessed()).toString();
    }

    public String getNumberOfDocuments() {
        NodesStatsResponse stats = (NodesStatsResponse)this.esa.getClient().admin().cluster().prepareNodesStats(new String[0]).execute().actionGet();
        return Long.valueOf(((NodeStats[])stats.getNodes())[0].getIndices().getDocs().getCount()).toString();
    }

    public String getNumberOfDeletedDocuments() {
        NodesStatsResponse stats = (NodesStatsResponse)this.esa.getClient().admin().cluster().prepareNodesStats(new String[0]).execute().actionGet();
        return Long.valueOf(((NodeStats[])stats.getNodes())[0].getIndices().getDocs().getDeleted()).toString();
    }

    public String getIndexingRates() {
        if (this.indexTimer == null) {
            MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
            this.indexTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "index"}));
        }
        return String.format("%.2f, %.2f, %.2f", this.indexTimer.getOneMinuteRate(), this.indexTimer.getFiveMinuteRate(), this.indexTimer.getFifteenMinuteRate());
    }

    public String getBulkIndexingRates() {
        if (this.bulkIndexTimer == null) {
            MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
            this.bulkIndexTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "bulkIndex"}));
        }
        return String.format("%.2f, %.2f, %.2f", this.bulkIndexTimer.getOneMinuteRate(), this.bulkIndexTimer.getFiveMinuteRate(), this.bulkIndexTimer.getFifteenMinuteRate());
    }

    public String getRootId() {
        return this.rootId;
    }

    public List<String> getRepositoryNames() {
        return this.esa.getRepositoryNames();
    }

    public void setRootId(String rootId) {
        this.rootId = rootId;
    }

    public String getNxql() {
        return this.nxql;
    }

    public void setNxql(String nxql) {
        this.nxql = nxql;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public Boolean getDropIndex() {
        return this.dropIndex;
    }

    public void setDropIndex(Boolean dropIndex) {
        this.dropIndex = dropIndex;
    }
}

