/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.oauth2;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.admin.oauth.DirectoryBasedEditor;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.oauth2.WEOAuthConstants;
import org.nuxeo.runtime.api.Framework;

@Name(value="oauth2ServiceProvidersActions")
@Scope(value=ScopeType.CONVERSATION)
public class OAuth2ServiceProvidersActionBean
extends DirectoryBasedEditor {
    private static final long serialVersionUID = 1L;
    protected static final String DIRECTORY = "oauth2ServiceProviders";
    protected static final String SCHEMA = "oauth2ServiceProvider";

    @Override
    protected String getDirectoryName() {
        return DIRECTORY;
    }

    @Override
    protected String getSchemaName() {
        return SCHEMA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAuthorizationURL(String entryId) throws ClientException {
        String url;
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(this.getDirectoryName());){
            DocumentModel entry = session.getEntry(entryId);
            NuxeoOAuth2ServiceProvider serviceProvider = NuxeoOAuth2ServiceProvider.createFromDirectoryEntry((DocumentModel)entry);
            NetHttpTransport HTTP_TRANSPORT = new NetHttpTransport();
            JacksonFactory JSON_FACTORY = new JacksonFactory();
            AuthorizationCodeFlow flow = serviceProvider.getAuthorizationCodeFlow((HttpTransport)HTTP_TRANSPORT, (JsonFactory)JSON_FACTORY);
            HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
            String redirectUrl = VirtualHostHelper.getServerURL((ServletRequest)request) + WEOAuthConstants.getInstalledAppCallbackURL(serviceProvider.getServiceName());
            AuthorizationCodeRequestUrl authorizationUrl = flow.newAuthorizationUrl();
            authorizationUrl.setRedirectUri(redirectUrl);
            url = authorizationUrl.build();
        }
        return url;
    }
}

