/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.io.IOException;
import org.nuxeo.ecm.core.redis.RedisCallable;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.Pool;

public class RedisPoolExecutor
implements RedisExecutor {
    protected Pool<Jedis> pool;

    public RedisPoolExecutor(Pool<Jedis> pool) {
        this.pool = pool;
    }

    @Override
    public <T> T execute(RedisCallable<T> callable) throws IOException, JedisException {
        Jedis jedis = (Jedis)this.pool.getResource();
        boolean brokenResource = false;
        try {
            T t = callable.call(jedis);
            return t;
        }
        catch (JedisConnectionException cause) {
            brokenResource = true;
            throw cause;
        }
        finally {
            if (brokenResource) {
                this.pool.returnBrokenResource((Object)jedis);
            } else {
                this.pool.returnResource((Object)jedis);
            }
        }
    }

    @Override
    public Pool<Jedis> getPool() {
        return this.pool;
    }
}

