/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ws;

import javax.annotation.security.PermitAll;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.api.ws.BaseNuxeoWebService;
import org.nuxeo.ecm.platform.api.ws.session.WSRemotingSession;
import org.nuxeo.ecm.platform.api.ws.session.WSRemotingSessionManager;
import org.nuxeo.ecm.platform.api.ws.session.impl.WSRemotingSessionImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractNuxeoWebService
implements BaseNuxeoWebService {
    private static final long serialVersionUID = 5530614356404354863L;
    private WSRemotingSessionManager sessionsManager;

    protected WSRemotingSessionManager getSessionsManager() {
        if (this.sessionsManager == null) {
            this.sessionsManager = (WSRemotingSessionManager)Framework.getService(WSRemotingSessionManager.class);
        }
        return this.sessionsManager;
    }

    @PermitAll
    @WebMethod
    public String connectOnRepository(@WebParam(name="userName") String username, @WebParam(name="password") String password, @WebParam(name="repositoryName") String repositoryName) throws ClientException {
        String sid = null;
        try {
            LoginContext loginContext = Framework.login();
            if (repositoryName == null) {
                RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
                repositoryName = repositoryManager.getDefaultRepositoryName();
            }
            sid = this._connect(username, password, repositoryName);
            loginContext.logout();
        }
        catch (LoginException e) {
            throw new ClientException(e.getMessage(), (Throwable)e);
        }
        return sid;
    }

    @Override
    @PermitAll
    @WebMethod
    public String connect(@WebParam(name="userName") String username, @WebParam(name="password") String password) throws ClientException {
        return this.connectOnRepository(username, password, null);
    }

    private String _connect(String username, String password, String repositoryName) throws ClientException {
        this.login(username, password);
        CoreSession session = CoreInstance.openCoreSession((String)repositoryName);
        String sid = session.getSessionId();
        UserManager userMgr = (UserManager)Framework.getService(UserManager.class);
        WSRemotingSessionImpl rs = new WSRemotingSessionImpl(session, userMgr, repositoryName, username, password);
        this.getSessionsManager().addSession(sid, rs);
        return sid;
    }

    @Override
    @WebMethod
    public void disconnect(@WebParam(name="sessionId") String sid) throws ClientException {
        WSRemotingSession rs = this.initSession(sid);
        rs.getDocumentManager().close();
    }

    protected void login(String username, String password) throws ClientException {
        try {
            Framework.login((String)username, (Object)password);
        }
        catch (LoginException e) {
            throw new ClientException("Login failed for " + username, (Throwable)e);
        }
    }

    protected WSRemotingSession initSession(String sid) throws ClientException {
        WSRemotingSession rs = this.getSessionsManager().getSession(sid);
        if (rs == null) {
            throw new ClientException("Invalid session id: " + sid);
        }
        this.login(rs.getUsername(), rs.getPassword());
        return rs;
    }
}

