/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ws;

import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.api.ws.DocumentLoader;
import org.nuxeo.ecm.platform.api.ws.DocumentProperty;
import org.nuxeo.ecm.platform.api.ws.session.WSRemotingSession;

public class DocumentSchemaLoader
implements DocumentLoader {
    @Override
    public void fillProperties(DocumentModel doc, List<DocumentProperty> props, WSRemotingSession rs) throws ClientException {
        String[] schemas;
        for (String schema : schemas = doc.getSchemas()) {
            DataModel dm = doc.getDataModel(schema);
            Map map = dm.getMap();
            for (Map.Entry entry : map.entrySet()) {
                this.collectNoBlobProperty("", (String)entry.getKey(), entry.getValue(), props);
            }
        }
    }

    protected void collectNoBlobProperty(String prefix, String name, Object value, List<DocumentProperty> props) throws ClientException {
        if (value instanceof Map) {
            Map map = (Map)value;
            prefix = prefix + name + '/';
            for (Map.Entry entry : map.entrySet()) {
                this.collectNoBlobProperty(prefix, (String)entry.getKey(), entry.getValue(), props);
            }
        } else if (value instanceof List) {
            prefix = prefix + name + '/';
            List list = (List)value;
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                this.collectNoBlobProperty(prefix, String.valueOf(i), list.get(i), props);
            }
        } else if (!(value instanceof Blob)) {
            if (value == null) {
                props.add(new DocumentProperty(prefix + name, null));
            } else {
                this.collectProperty(prefix, name, value, props);
            }
        }
    }

    protected void collectProperty(String prefix, String name, Object value, List<DocumentProperty> props) throws ClientException {
        String STRINGS_LIST_SEP = ";";
        if (value instanceof Map) {
            Map map = (Map)value;
            prefix = prefix + name + '/';
            for (Map.Entry entry : map.entrySet()) {
                this.collectProperty(prefix, (String)entry.getKey(), entry.getValue(), props);
            }
        } else if (value instanceof List) {
            prefix = prefix + name + '/';
            List list = (List)value;
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                this.collectProperty(prefix, String.valueOf(i), list.get(i), props);
            }
        } else {
            String strValue = null;
            if (value != null) {
                if (value instanceof Blob) {
                    try {
                        byte[] bytes = ((Blob)value).getByteArray();
                        strValue = Base64.encodeBase64String((byte[])bytes);
                    }
                    catch (IOException e) {
                        throw new ClientException("Failed to get blob property value", (Throwable)e);
                    }
                } else if (value instanceof Calendar) {
                    strValue = ((Calendar)value).getTime().toString();
                } else if (value instanceof String[]) {
                    for (String each : (String[])value) {
                        strValue = strValue == null ? each : strValue + ";" + each;
                    }
                } else if (value instanceof List) {
                    for (String each : (List)value) {
                        if (strValue == null) {
                            strValue = each;
                            continue;
                        }
                        strValue = strValue + ";" + each;
                    }
                } else {
                    strValue = value.toString();
                }
            }
            props.add(new DocumentProperty(prefix + name, strValue));
        }
    }
}

