/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model;

import java.util.HashMap;
import java.util.Map;

public abstract class ContributionFragmentRegistry<T> {
    protected Map<String, FragmentList<T>> contribs = new HashMap<String, FragmentList<T>>();

    public abstract String getContributionId(T var1);

    public abstract void contributionUpdated(String var1, T var2, T var3);

    public abstract void contributionRemoved(String var1, T var2);

    public abstract T clone(T var1);

    public abstract void merge(T var1, T var2);

    public boolean isSupportingMerge() {
        return true;
    }

    public synchronized void addContribution(T contrib) {
        String id = this.getContributionId(contrib);
        FragmentList<T> head = this.addFragment(id, contrib);
        this.contributionUpdated(id, head.merge(this), contrib);
    }

    public synchronized void removeContribution(T contrib) {
        this.removeContribution(contrib, false);
    }

    public synchronized void removeContribution(T contrib, boolean useEqualsMethod) {
        String id = this.getContributionId(contrib);
        FragmentList<T> head = this.removeFragment(id, contrib, useEqualsMethod);
        if (head != null) {
            T result = head.merge(this);
            if (result != null) {
                this.contributionUpdated(id, result, contrib);
            } else {
                this.contributionRemoved(id, contrib);
            }
        }
    }

    protected synchronized T getContribution(String id) {
        FragmentList<T> head = this.contribs.get(id);
        return head != null ? (T)head.merge(this) : null;
    }

    public synchronized FragmentList<T>[] getFragments() {
        return this.contribs.values().toArray(new FragmentList[this.contribs.size()]);
    }

    protected FragmentList<T> addFragment(String id, T contrib) {
        FragmentList<T> head = this.contribs.get(id);
        if (head == null) {
            head = new FragmentList();
            this.contribs.put(id, head);
        }
        head.add(contrib);
        return head;
    }

    protected FragmentList<T> removeFragment(String id, T contrib, boolean useEqualsMethod) {
        FragmentList<T> head = this.contribs.get(id);
        if (head == null) {
            return null;
        }
        if (head.remove(contrib, useEqualsMethod)) {
            if (head.isEmpty()) {
                this.contribs.remove(id);
            }
            return head;
        }
        return null;
    }

    public static class Fragment<T> {
        public T object;
        public Fragment<T> next;
        public Fragment<T> prev;

        public Fragment(T object) {
            this.object = object;
        }

        public final void insertBefore(Fragment<T> fragment) {
            fragment.prev = this.prev;
            fragment.next = this;
            this.prev.next = fragment;
            this.prev = fragment;
        }

        public final void insertAfter(Fragment<T> fragment) {
            fragment.prev = this;
            fragment.next = this.next;
            this.next.prev = fragment;
            this.next = fragment;
        }

        public final void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = null;
            this.next = null;
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        public final boolean hasPrev() {
            return this.prev != null;
        }
    }

    public static class FragmentList<T>
    extends Fragment<T> {
        public FragmentList() {
            super(null);
            this.prev = this;
            this.next = this;
        }

        public boolean isEmpty() {
            return this.next == null;
        }

        public T merge(ContributionFragmentRegistry<T> reg) {
            Object mergedValue = this.object;
            if (mergedValue != null) {
                return (T)mergedValue;
            }
            Fragment p = this.next;
            if (p == this) {
                return null;
            }
            mergedValue = reg.isSupportingMerge() ? reg.clone(p.object) : p.object;
            p = p.next;
            while (p != this) {
                if (reg.isSupportingMerge()) {
                    reg.merge(p.object, mergedValue);
                } else {
                    mergedValue = p.object;
                }
                p = p.next;
            }
            this.object = mergedValue;
            return (T)mergedValue;
        }

        public final void add(T contrib) {
            this.insertBefore(new Fragment<T>(contrib));
            this.object = null;
        }

        public final void add(Fragment<T> fragment) {
            this.insertBefore(fragment);
            this.object = null;
        }

        public boolean remove(T contrib) {
            return this.remove(contrib, false);
        }

        public boolean remove(T contrib, boolean useEqualsMethod) {
            Fragment p = this.next;
            while (p != this) {
                if (useEqualsMethod && p.object != null && p.object.equals(contrib) || !useEqualsMethod && p.object == contrib) {
                    p.remove();
                    this.object = null;
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }
}

