/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.platform.rendering.api.DocumentView;
import org.nuxeo.ecm.platform.rendering.fm.adapters.SchemaTemplate;

public class DefaultDocumentView
implements DocumentView {
    public static final Object UNKNOWN = new Object();
    protected final Map<String, Field> fields;
    protected static final Field SESSION = new Field(){

        @Override
        public final String getName() {
            return "session";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getCoreSession();
        }
    };
    protected static final Field ID = new Field(){

        @Override
        public final String getName() {
            return "id";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getId();
        }
    };
    protected static final Field NAME = new Field(){

        @Override
        public final String getName() {
            return "name";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getName();
        }
    };
    protected static final Field PATH = new Field(){

        @Override
        public final String getName() {
            return "path";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getPathAsString();
        }
    };
    protected static final Field TYPE = new Field(){

        @Override
        public final String getName() {
            return "type";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getType();
        }
    };
    protected static final Field SCHEMAS = new Field(){

        @Override
        public final String getName() {
            return "schemas";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getSchemas();
        }
    };
    protected static final Field FACETS = new Field(){

        @Override
        public final String getName() {
            return "facets";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getFacets();
        }
    };
    protected static final Field STATE = new Field(){

        @Override
        public final String getName() {
            return "state";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getCurrentLifeCycleState();
        }
    };
    protected static final Field LOCKED = new Field(){

        @Override
        public final String getName() {
            return "isLocked";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.isLocked();
        }
    };
    protected static final Field LIFE_CYCLE_STATE = new Field(){

        @Override
        public final String getName() {
            return "lifeCycleState";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getCurrentLifeCycleState();
        }
    };
    protected static final Field LIFE_CYCLE_POLICY = new Field(){

        @Override
        public final String getName() {
            return "lifeCyclePolicy";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getLifeCyclePolicy();
        }
    };
    protected static final Field ALLOWED_STATE_TRANSITIONS = new Field(){

        @Override
        public final String getName() {
            return "allowedStateTransitions";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getAllowedStateTransitions();
        }
    };
    protected static final Field IS_FOLDER = new Field(){

        @Override
        public final String getName() {
            return "isFolder";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getFacets().contains("Folderish");
        }
    };
    protected static final Field TITLE = new Field(){

        @Override
        public String getName() {
            return "title";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getTitle();
        }
    };
    protected static final Field AUTHOR = new Field(){

        @Override
        public String getName() {
            return "author";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            try {
                return doc.getPropertyValue("dc:creator");
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                return null;
            }
        }
    };
    protected static final Field CREATED = new Field(){

        @Override
        public String getName() {
            return "created";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            try {
                Calendar cal = (Calendar)doc.getPropertyValue("dc:created");
                if (cal != null) {
                    return cal.getTime();
                }
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
            return null;
        }
    };
    protected static final Field MODIFIED = new Field(){

        @Override
        public String getName() {
            return "modified";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            try {
                Calendar cal = (Calendar)doc.getPropertyValue("dc:modified");
                if (cal != null) {
                    return cal.getTime();
                }
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
            return null;
        }
    };
    protected static final Field CONTENT = new Field(){

        @Override
        public String getName() {
            return "content";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            try {
                Blob blob = (Blob)doc.getPropertyValue("file:content");
                if (blob != null) {
                    return blob;
                }
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
            return new StringBlob("", "text/plain");
        }
    };
    protected static final Field SID = new Field(){

        @Override
        public String getName() {
            return "sessionId";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getSessionId();
        }
    };
    protected static final Field REPOSITORY = new Field(){

        @Override
        public String getName() {
            return "repository";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getRepositoryName();
        }
    };
    protected static final Field PARENT = new Field(){

        @Override
        public String getName() {
            return "parent";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            CoreSession session = doc.getCoreSession();
            return session.getParentDocument(doc.getRef());
        }
    };
    protected static final Field CHILDREN = new Field(){

        @Override
        public String getName() {
            return "children";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            CoreSession session = doc.getCoreSession();
            return session.getChildren(doc.getRef());
        }
    };
    protected static final Field REF = new Field(){

        @Override
        public String getName() {
            return "ref";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getRef();
        }
    };
    protected static final Field VERSIONS = new Field(){

        @Override
        public String getName() {
            return "versions";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            CoreSession session = doc.getCoreSession();
            return session.getVersions(doc.getRef());
        }
    };
    protected static final Field PROXIES = new Field(){

        @Override
        public String getName() {
            return "proxies";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            CoreSession session = doc.getCoreSession();
            return session.getProxies(doc.getRef(), null);
        }
    };
    protected static final Field VERSION_LABEL = new Field(){

        @Override
        public String getName() {
            return "versionLabel";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getVersionLabel();
        }
    };
    protected static final Field SOURCE_ID = new Field(){

        @Override
        public String getName() {
            return "sourceId";
        }

        @Override
        public Object getValue(DocumentModel doc) {
            return doc.getSourceId();
        }
    };
    public static final DefaultDocumentView DEFAULT = new DefaultDocumentView();

    public DefaultDocumentView() {
        this.fields = new HashMap<String, Field>();
        this.initialize();
    }

    public DefaultDocumentView(Map<String, Field> fields) {
        this.fields = fields == null ? new HashMap() : fields;
    }

    protected void initialize() {
        this.addField(SESSION);
        this.addField(ID);
        this.addField(NAME);
        this.addField(PATH);
        this.addField(TYPE);
        this.addField(SID);
        this.addField(REPOSITORY);
        this.addField(SCHEMAS);
        this.addField(FACETS);
        this.addField(LOCKED);
        this.addField(LIFE_CYCLE_STATE);
        this.addField(LIFE_CYCLE_POLICY);
        this.addField(ALLOWED_STATE_TRANSITIONS);
        this.addField(IS_FOLDER);
        this.addField(TITLE);
        this.addField(AUTHOR);
        this.addField(CREATED);
        this.addField(MODIFIED);
        this.addField(CONTENT);
        this.addField(PARENT);
        this.addField(CHILDREN);
        this.addField(REF);
        this.addField(VERSIONS);
        this.addField(PROXIES);
        this.addField(VERSION_LABEL);
        this.addField(SOURCE_ID);
    }

    public final void addField(Field field) {
        this.fields.put(field.getName(), field);
    }

    public final void addFields(Collection<Field> fields) {
        for (Field field : fields) {
            this.fields.put(field.getName(), field);
        }
    }

    public final void removeField(String name) {
        this.fields.remove(name);
    }

    public Field getField(String name) {
        return this.fields.get(name);
    }

    @Override
    public Object get(DocumentModel doc, String name) throws PropertyException {
        Field field = this.fields.get(name);
        if (field != null) {
            return field.getValue(doc);
        }
        if (name.indexOf(58) > -1) {
            return doc.getProperty(name);
        }
        if (doc.hasSchema(name)) {
            return new SchemaTemplate.DocumentSchema(doc, name);
        }
        return UNKNOWN;
    }

    @Override
    public Collection<String> keys(DocumentModel doc) {
        ArrayList<String> keys = new ArrayList<String>(this.fields.keySet());
        keys.addAll(Arrays.asList(doc.getSchemas()));
        return keys;
    }

    public Map<String, Field> getFields() {
        return this.fields;
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public int size(DocumentModel doc) {
        return this.fields.size() + doc.getSchemas().length;
    }

    public static interface Field {
        public String getName();

        public Object getValue(DocumentModel var1);
    }
}

