/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.fm.adapters;

import freemarker.ext.beans.ArrayModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.SimpleDate;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.platform.rendering.fm.adapters.BlobTemplate;
import org.nuxeo.ecm.platform.rendering.fm.adapters.ComplexPropertyTemplate;
import org.nuxeo.ecm.platform.rendering.fm.adapters.DocumentObjectWrapper;
import org.nuxeo.ecm.platform.rendering.fm.adapters.ListPropertyTemplate;

public class PropertyWrapper {
    protected final DocumentObjectWrapper wrapper;

    public PropertyWrapper(DocumentObjectWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public TemplateModel wrap(Property property) throws TemplateModelException {
        try {
            if (property.isScalar()) {
                Serializable value = property.getValue();
                if (value == null) {
                    return TemplateModel.NOTHING;
                }
                if (property.getType() == DateType.INSTANCE) {
                    return new SimpleDate(((Calendar)value).getTime(), 3);
                }
                return this.wrapper.wrap(value);
            }
            if (property.isList()) {
                Serializable value;
                if (property.isContainer()) {
                    return new ListPropertyTemplate(this.wrapper, (ListProperty)property);
                }
                try {
                    value = property.getValue();
                }
                catch (PropertyException e) {
                    throw new IllegalArgumentException("Cannot get array from array property " + property);
                }
                if (value == null) {
                    return TemplateModel.NOTHING;
                }
                if (value instanceof ArrayList) {
                    return new ListPropertyTemplate(this.wrapper, (ListProperty)property);
                }
                return new ArrayModel((Object)value, (BeansWrapper)this.wrapper);
            }
            if (property.getClass() == BlobProperty.class) {
                return new BlobTemplate(this.wrapper, (Blob)property.getValue());
            }
            return new ComplexPropertyTemplate(this.wrapper, property);
        }
        catch (PropertyException e) {
            throw new TemplateModelException((Exception)((Object)e));
        }
    }
}

