/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelSetup;
import org.nuxeo.ecm.core.storage.sql.RepositoryBackend;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.ClusterNodeHandler;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnectionPropagator;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapperConnector;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCMapperTxSuspender;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.ConnectionHelper;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;

public class JDBCBackend
implements RepositoryBackend {
    private static final Log log = LogFactory.getLog(JDBCBackend.class);
    private RepositoryImpl repository;
    private String pseudoDataSourceName;
    private XADataSource xadatasource;
    private Dialect dialect;
    private SQLInfo sqlInfo;
    private boolean firstMapper = true;
    private ClusterNodeHandler clusterNodeHandler;
    private JDBCConnectionPropagator connectionPropagator = new JDBCConnectionPropagator();
    protected boolean isPooledDataSource;

    @Override
    public void initialize(RepositoryImpl repository) throws StorageException {
        Object instance;
        Class<?> klass;
        this.repository = repository;
        RepositoryDescriptor repositoryDescriptor = repository.getRepositoryDescriptor();
        this.pseudoDataSourceName = ConnectionHelper.getPseudoDataSourceNameForRepository((String)repositoryDescriptor.name);
        try {
            DataSource ds = DataSourceHelper.getDataSource((String)this.pseudoDataSourceName);
            if (ds instanceof PooledDataSourceRegistry.PooledDataSource) {
                this.isPooledDataSource = true;
                return;
            }
        }
        catch (NamingException cause) {
            // empty catch block
        }
        try (Connection connection = ConnectionHelper.getConnection((String)this.pseudoDataSourceName);){
            if (connection != null) {
                return;
            }
        }
        catch (SQLException cause) {
            throw new StorageException("Connection error", cause);
        }
        String className = repositoryDescriptor.xaDataSourceName;
        try {
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new StorageException("Unknown class: " + className, e);
        }
        try {
            instance = klass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new StorageException("Cannot instantiate class: " + className, e);
        }
        if (!(instance instanceof XADataSource)) {
            throw new StorageException("Not a XADataSource: " + className);
        }
        this.xadatasource = (XADataSource)instance;
        for (Map.Entry<String, String> entry : repositoryDescriptor.properties.entrySet()) {
            String name = entry.getKey();
            String value = Framework.expandVars((String)entry.getValue());
            if (name.contains("/")) {
                name = name.substring(0, name.indexOf(47));
            }
            if (Character.isLowerCase(name.charAt(1))) {
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            try {
                BeanUtils.setProperty((Object)this.xadatasource, (String)name, (Object)value);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)String.format("Cannot set %s = %s", name, value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeModelSetup(ModelSetup modelSetup) throws StorageException {
        try {
            XAConnection xaconnection = null;
            Connection connection = ConnectionHelper.getConnection((String)this.pseudoDataSourceName);
            try {
                if (connection == null) {
                    xaconnection = this.xadatasource.getXAConnection();
                    connection = xaconnection.getConnection();
                }
                this.dialect = Dialect.createDialect(connection, this.repository.getBinaryManager(), this.repository.getRepositoryDescriptor());
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
                if (xaconnection != null) {
                    xaconnection.close();
                }
            }
        }
        catch (SQLException | ResourceException cause) {
            throw new StorageException("Cannot connect to database", cause);
        }
        modelSetup.materializeFulltextSyntheticColumn = this.dialect.getMaterializeFulltextSyntheticColumn();
        modelSetup.supportsArrayColumns = this.dialect.supportsArrayColumns();
        switch (this.dialect.getIdType()) {
            case VARCHAR: 
            case UUID: {
                modelSetup.idType = Model.IdType.STRING;
                break;
            }
            case SEQUENCE: {
                modelSetup.idType = Model.IdType.LONG;
                break;
            }
            default: {
                throw new AssertionError((Object)this.dialect.getIdType().toString());
            }
        }
    }

    @Override
    public void initializeModel(Model model) throws StorageException {
        this.sqlInfo = new SQLInfo(model, this.dialect);
    }

    @Override
    public Mapper newMapper(Model model, Session.PathResolver pathResolver, RepositoryBackend.MapperKind kind) throws StorageException {
        boolean noSharing = kind == RepositoryBackend.MapperKind.LOCK_MANAGER || kind == RepositoryBackend.MapperKind.CLUSTER_NODE_HANDLER;
        boolean noInvalidationPropagation = kind == RepositoryBackend.MapperKind.LOCK_MANAGER;
        RepositoryDescriptor repositoryDescriptor = this.repository.getRepositoryDescriptor();
        ClusterNodeHandler cnh = noInvalidationPropagation ? null : this.clusterNodeHandler;
        Mapper mapper = new JDBCMapper(model, pathResolver, this.sqlInfo, this.xadatasource, cnh, this.connectionPropagator, noSharing, this.repository);
        if (this.isPooledDataSource) {
            mapper = JDBCMapperConnector.newConnector(mapper);
            if (noSharing) {
                mapper = JDBCMapperTxSuspender.newConnector(mapper);
            }
        } else {
            mapper.connect();
        }
        if (this.firstMapper) {
            this.firstMapper = false;
            if (repositoryDescriptor.getNoDDL()) {
                log.info((Object)"Skipping database creation");
            } else {
                mapper.createDatabase();
            }
        }
        if (kind == RepositoryBackend.MapperKind.CLUSTER_NODE_HANDLER) {
            this.clusterNodeHandler = new ClusterNodeHandler(mapper, repositoryDescriptor);
            this.connectionPropagator.setClusterNodeHandler(this.clusterNodeHandler);
        }
        return mapper;
    }

    @Override
    public void shutdown() throws StorageException {
        if (this.clusterNodeHandler != null) {
            this.clusterNodeHandler.close();
        }
    }
}

