/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.nuxeo.ecm.core.storage.sql.Mapper;

public class JDBCMapperConnector
implements InvocationHandler {
    protected final Mapper mapper;

    protected JDBCMapperConnector(Mapper mapper) {
        this.mapper = mapper;
    }

    protected Object doInvoke(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)this.mapper, args);
        }
        catch (InvocationTargetException cause) {
            throw cause.getTargetException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.mapper.isConnected()) {
            return this.doInvoke(method, args);
        }
        String name = method.getName();
        if ("start".equals(name)) {
            return 0;
        }
        if ("end".equals(name)) {
            return null;
        }
        if ("prepare".equals(name)) {
            return 0;
        }
        if ("commit".equals(name)) {
            return null;
        }
        if ("rollback".equals(name)) {
            return null;
        }
        if ("close".equals(name)) {
            return null;
        }
        if ("clearCache".equals(name)) {
            return this.doInvoke(method, args);
        }
        if ("close".equals(name)) {
            return null;
        }
        this.mapper.connect();
        try {
            Object object = this.doInvoke(method, args);
            return object;
        }
        finally {
            if (this.mapper.isConnected()) {
                this.mapper.disconnect();
            }
        }
    }

    public static Mapper newConnector(Mapper mapper) {
        return (Mapper)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Mapper.class}, (InvocationHandler)new JDBCMapperConnector(mapper));
    }
}

