/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.InvalidationsQueue;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.SelectionType;
import org.nuxeo.ecm.core.storage.sql.jdbc.ACLCollectionIO;
import org.nuxeo.ecm.core.storage.sql.jdbc.ClusterNodeHandler;
import org.nuxeo.ecm.core.storage.sql.jdbc.CollectionIO;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnection;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnectionPropagator;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.ScalarCollectionIO;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Update;

public class JDBCRowMapper
extends JDBCConnection
implements RowMapper {
    public static final int UPDATE_BATCH_SIZE = 100;
    public static final int DEBUG_MAX_TREE = 50;
    private final ClusterNodeHandler clusterNodeHandler;
    private final InvalidationsQueue queue;

    public JDBCRowMapper(Model model, SQLInfo sqlInfo, XADataSource xadatasource, ClusterNodeHandler clusterNodeHandler, JDBCConnectionPropagator connectionPropagator, boolean noSharing) throws StorageException {
        super(model, sqlInfo, xadatasource, connectionPropagator, noSharing);
        this.clusterNodeHandler = clusterNodeHandler;
        if (clusterNodeHandler != null) {
            this.queue = new InvalidationsQueue("cluster-" + this);
            clusterNodeHandler.addQueue(this.queue);
        } else {
            this.queue = null;
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.clusterNodeHandler != null) {
            this.clusterNodeHandler.removeQueue(this.queue);
        }
    }

    @Override
    public Invalidations receiveInvalidations() throws StorageException {
        if (this.clusterNodeHandler != null && this.connection != null) {
            this.receiveClusterInvalidations();
            return this.queue.getInvalidations();
        }
        return null;
    }

    protected void receiveClusterInvalidations() throws StorageException {
        Invalidations invalidations = this.clusterNodeHandler.receiveClusterInvalidations();
        if (invalidations != null && !invalidations.isEmpty()) {
            this.clusterNodeHandler.propagateInvalidations(invalidations, null);
        }
    }

    @Override
    public void sendInvalidations(Invalidations invalidations) throws StorageException {
        if (this.clusterNodeHandler != null) {
            this.clusterNodeHandler.sendClusterInvalidations(invalidations);
        }
    }

    @Override
    public void clearCache() {
    }

    @Override
    public long getCacheSize() {
        return 0L;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.xaresource.rollback(xid);
        }
        catch (XAException e) {
            this.logger.error("XA error on rollback: " + e);
            throw e;
        }
    }

    protected CollectionIO getCollectionIO(String tableName) {
        return tableName.equals("acls") ? ACLCollectionIO.INSTANCE : ScalarCollectionIO.INSTANCE;
    }

    @Override
    public Serializable generateNewId() throws StorageException {
        try {
            return this.generateNewIdInternal();
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    protected Serializable generateNewIdInternal() throws SQLException {
        return this.dialect.getGeneratedId(this.connection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<? extends RowId> read(Collection<RowId> rowIds, boolean cacheOnly) throws StorageException {
        ArrayList<RowId> res = new ArrayList<RowId>(rowIds.size());
        if (cacheOnly) {
            for (RowId rowId : rowIds) {
                res.add(new RowId(rowId));
            }
            return res;
        }
        HashMap<String, HashSet<Serializable>> tableIds = new HashMap<String, HashSet<Serializable>>();
        for (RowId rowId : rowIds) {
            HashSet<Serializable> ids = (HashSet<Serializable>)tableIds.get(rowId.tableName);
            if (ids == null) {
                ids = new HashSet<Serializable>();
                tableIds.put(rowId.tableName, ids);
            }
            ids.add(rowId.id);
        }
        for (Map.Entry entry : tableIds.entrySet()) {
            List<Object> rows;
            int chunkSize;
            String tableName = (String)entry.getKey();
            HashSet<Serializable> ids = new HashSet<Serializable>((Collection)entry.getValue());
            int size = ids.size();
            if (size > (chunkSize = this.sqlInfo.getMaximumArgsForIn())) {
                void var13_18;
                ArrayList idList = new ArrayList(ids);
                rows = new ArrayList(size);
                boolean bl = false;
                while (var13_18 < size) {
                    int end = var13_18 + chunkSize;
                    if (end > size) {
                        end = size;
                    }
                    ArrayList<Serializable> chunkIds = new ArrayList<Serializable>(idList.subList((int)var13_18, end));
                    List<Row> chunkRows = this.model.isCollectionFragment(tableName) ? this.readCollectionArrays(tableName, chunkIds) : this.readSimpleRows(tableName, chunkIds);
                    rows.addAll(chunkRows);
                    var13_18 += chunkSize;
                }
            } else {
                rows = this.model.isCollectionFragment(tableName) ? this.readCollectionArrays(tableName, ids) : this.readSimpleRows(tableName, ids);
            }
            for (Row row : rows) {
                res.add(row);
                ids.remove(row.id);
            }
            for (Serializable serializable : ids) {
                res.add(new RowId(tableName, serializable));
            }
        }
        return res;
    }

    protected List<Row> readSimpleRows(String tableName, Collection<Serializable> ids) throws StorageException {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectFragmentsByIds(tableName, ids.size());
        Map<String, Serializable> criteriaMap = Collections.singletonMap("id", (Serializable)((Object)ids));
        return this.getSelectRows(tableName, select, criteriaMap, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Row> readCollectionArrays(String tableName, Collection<Serializable> ids) throws StorageException {
        LinkedList<Row> linkedList;
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        String[] stringArray = new String[2];
        stringArray[0] = "id";
        stringArray[1] = "pos";
        String[] orderBys = stringArray;
        String[] stringArray2 = new String[1];
        stringArray2[0] = "pos";
        HashSet<String> skipColumns = new HashSet<String>(Arrays.asList(stringArray2));
        SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectFragmentsByIds(tableName, ids.size(), orderBys, skipColumns);
        String sql = select.sql;
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, ids);
        }
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            int i = 1;
            for (Serializable id : ids) {
                this.dialect.setId(ps, i++, id);
            }
            ResultSet rs = ps.executeQuery();
            this.countExecute();
            CollectionIO io = this.getCollectionIO(tableName);
            PropertyType ftype = this.model.getCollectionFragmentType(tableName);
            PropertyType type = ftype.getArrayBaseType();
            Serializable curId = null;
            ArrayList<Serializable> list = null;
            Serializable[] returnId = new Serializable[1];
            int[] returnPos = new int[]{-1};
            LinkedList<Row> res = new LinkedList<Row>();
            HashSet<Serializable> remainingIds = new HashSet<Serializable>(ids);
            while (rs.next()) {
                Serializable value = io.getCurrentFromResultSet(rs, select.whatColumns, this.model, returnId, returnPos);
                Serializable newId = returnId[0];
                if (newId != null && !newId.equals(curId)) {
                    if (list != null) {
                        res.add(new Row(tableName, curId, type.collectionToArray(list)));
                        remainingIds.remove(curId);
                    }
                    curId = newId;
                    list = new ArrayList<Serializable>();
                }
                list.add(value);
            }
            if (curId != null && list != null) {
                res.add(new Row(tableName, curId, type.collectionToArray(list)));
                remainingIds.remove(curId);
            }
            if (!remainingIds.isEmpty()) {
                Serializable[] emptyArray = ftype.getEmptyArray();
                for (Serializable id : remainingIds) {
                    res.add(new Row(tableName, id, emptyArray));
                }
            }
            if (this.logger.isLogEnabled()) {
                for (Row row : res) {
                    this.logger.log("  -> " + row);
                }
            }
            linkedList = res;
        }
        catch (Throwable throwable) {
            try {
                this.closeStatement(ps);
                throw throwable;
            }
            catch (SQLException e) {
                this.checkConnectionReset(e);
                throw new StorageException("Could not select: " + sql, e);
            }
        }
        this.closeStatement(ps);
        return linkedList;
    }

    protected List<Row> getSelectRows(String tableName, SQLInfo.SQLInfoSelect select, Map<String, Serializable> criteriaMap, Map<String, Serializable> joinMap, boolean limitToOne) throws StorageException {
        LinkedList<Row> list = new LinkedList<Row>();
        if (select.whatColumns.isEmpty() && select.whereColumns.size() == 1) {
            if (select.whereColumns.get(0).getKey() == "id" && joinMap == null) {
                Row row = new Row(tableName, criteriaMap);
                if (select.opaqueColumns != null) {
                    for (Column column : select.opaqueColumns) {
                        row.putNew(column.getKey(), Row.OPAQUE);
                    }
                }
                list.add(row);
                return list;
            }
        }
        if (joinMap == null) {
            joinMap = Collections.emptyMap();
        }
        PreparedStatement ps = null;
        try {
            List<Row> list2;
            ps = this.connection.prepareStatement(select.sql);
            LinkedList<Serializable> debugValues = null;
            if (this.logger.isLogEnabled()) {
                debugValues = new LinkedList<Serializable>();
            }
            int i = 1;
            for (Column column : select.whereColumns) {
                Serializable v;
                String key = column.getKey();
                if (criteriaMap.containsKey(key)) {
                    v = criteriaMap.get(key);
                } else if (joinMap.containsKey(key)) {
                    v = joinMap.get(key);
                } else {
                    throw new RuntimeException(key);
                }
                if (v == null) {
                    throw new StorageException("Null value for key: " + key);
                }
                if (v instanceof Collection) {
                    for (Object vv : (Collection)((Object)v)) {
                        column.setToPreparedStatement(ps, i++, (Serializable)vv);
                        if (debugValues == null) continue;
                        debugValues.add((Serializable)vv);
                    }
                    continue;
                }
                column.setToPreparedStatement(ps, i++, v);
                if (debugValues == null) continue;
                debugValues.add(v);
            }
            if (debugValues != null) {
                this.logger.logSQL(select.sql, debugValues);
            }
            ResultSet rs = ps.executeQuery();
            this.countExecute();
            while (rs.next()) {
                Row row = new Row(tableName, criteriaMap);
                i = 1;
                for (Column column : select.whatColumns) {
                    row.put(column.getKey(), column.getFromResultSet(rs, i++));
                }
                if (select.opaqueColumns != null) {
                    for (Column column : select.opaqueColumns) {
                        row.putNew(column.getKey(), Row.OPAQUE);
                    }
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.logResultSet(rs, select.whatColumns);
                }
                list.add(row);
                if (!limitToOne) continue;
                LinkedList<Row> i$ = list;
                return i$;
            }
            if (limitToOne) {
                list2 = Collections.emptyList();
                return list2;
            }
            list2 = list;
            return list2;
        }
        catch (SQLException e) {
            this.checkConnectionReset(e, true);
            this.checkConcurrentUpdate(e);
            throw new StorageException("Could not select: " + select.sql, e);
        }
        finally {
            if (ps != null) {
                try {
                    this.closeStatement(ps);
                }
                catch (SQLException e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void write(RowMapper.RowBatch batch) throws StorageException {
        if (!batch.creates.isEmpty()) {
            this.writeCreates(batch.creates);
        }
        if (!batch.updates.isEmpty()) {
            this.writeUpdates(batch.updates);
        }
        if (!batch.deletes.isEmpty()) {
            this.writeDeletes(batch.deletes);
        }
    }

    protected void writeCreates(List<Row> creates) throws StorageException {
        LinkedHashMap tableRows = new LinkedHashMap();
        tableRows.put("hierarchy", new LinkedList());
        for (Row row : creates) {
            LinkedList<Row> rows = (LinkedList<Row>)tableRows.get(row.tableName);
            if (rows == null) {
                rows = new LinkedList<Row>();
                tableRows.put(row.tableName, rows);
            }
            rows.add(row);
        }
        for (Map.Entry entry : tableRows.entrySet()) {
            String tableName = (String)entry.getKey();
            List rows = (List)entry.getValue();
            if (this.model.isCollectionFragment(tableName)) {
                this.insertCollectionRows(tableName, rows);
                continue;
            }
            this.insertSimpleRows(tableName, rows);
        }
    }

    protected void writeUpdates(Set<RowMapper.RowUpdate> updates) throws StorageException {
        HashMap<String, LinkedList<RowMapper.RowUpdate>> tableRows = new HashMap<String, LinkedList<RowMapper.RowUpdate>>();
        for (RowMapper.RowUpdate rowUpdate : updates) {
            LinkedList<RowMapper.RowUpdate> rows = (LinkedList<RowMapper.RowUpdate>)tableRows.get(rowUpdate.row.tableName);
            if (rows == null) {
                rows = new LinkedList<RowMapper.RowUpdate>();
                tableRows.put(rowUpdate.row.tableName, rows);
            }
            rows.add(rowUpdate);
        }
        for (Map.Entry entry : tableRows.entrySet()) {
            String tableName = (String)entry.getKey();
            List rows = (List)entry.getValue();
            if (this.model.isCollectionFragment(tableName)) {
                this.updateCollectionRows(tableName, rows);
                continue;
            }
            this.updateSimpleRows(tableName, rows);
        }
    }

    protected void writeDeletes(Collection<RowId> deletes) throws StorageException {
        HashMap<String, HashSet<Serializable>> tableIds = new HashMap<String, HashSet<Serializable>>();
        for (RowId rowId : deletes) {
            HashSet<Serializable> ids = (HashSet<Serializable>)tableIds.get(rowId.tableName);
            if (ids == null) {
                ids = new HashSet<Serializable>();
                tableIds.put(rowId.tableName, ids);
            }
            ids.add(rowId.id);
        }
        for (Map.Entry entry : tableIds.entrySet()) {
            String tableName = (String)entry.getKey();
            Set ids = (Set)entry.getValue();
            this.deleteRows(tableName, ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertSimpleRows(String tableName, List<Row> rows) throws StorageException {
        if (rows.isEmpty()) {
            return;
        }
        String sql = this.sqlInfo.getInsertSql(tableName);
        if (sql == null) {
            throw new StorageException("Unknown table: " + tableName);
        }
        String loggedSql = this.supportsBatchUpdates && rows.size() > 1 ? sql + " -- BATCHED" : sql;
        List<Column> columns = this.sqlInfo.getInsertColumns(tableName);
        try {
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                int batch = 0;
                for (Row row : rows) {
                    ++batch;
                    if (this.logger.isLogEnabled()) {
                        this.logger.logSQL(loggedSql, columns, row);
                    }
                    int i = 1;
                    for (Column column : columns) {
                        column.setToPreparedStatement(ps, i++, row.get(column.getKey()));
                    }
                    if (this.supportsBatchUpdates) {
                        ps.addBatch();
                        if (batch % 100 != 0) continue;
                        ps.executeBatch();
                        this.countExecute();
                        continue;
                    }
                    ps.execute();
                    this.countExecute();
                }
                if (this.supportsBatchUpdates) {
                    ps.executeBatch();
                    this.countExecute();
                }
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            if (e instanceof BatchUpdateException) {
                BatchUpdateException bue = (BatchUpdateException)e;
                if (e.getCause() == null && bue.getNextException() != null) {
                    e.initCause(bue.getNextException());
                }
            }
            this.checkConcurrentUpdate(e);
            throw new StorageException("Could not insert: " + sql, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertCollectionRows(String tableName, List<Row> rows) throws StorageException {
        if (rows.isEmpty()) {
            return;
        }
        String sql = this.sqlInfo.getInsertSql(tableName);
        List<Column> columns = this.sqlInfo.getInsertColumns(tableName);
        CollectionIO io = this.getCollectionIO(tableName);
        try {
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                io.executeInserts(ps, rows, columns, this.supportsBatchUpdates, sql, this);
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not insert: " + sql, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSimpleRows(String tableName, List<RowMapper.RowUpdate> rows) throws StorageException {
        if (rows.isEmpty()) {
            return;
        }
        HashMap<String, LinkedList<RowMapper.RowUpdate>> updatesByCanonKeys = new HashMap<String, LinkedList<RowMapper.RowUpdate>>();
        HashMap<String, Collection<String>> keysByCanonKeys = new HashMap<String, Collection<String>>();
        HashMap deltasByCanonKeys = new HashMap();
        for (RowMapper.RowUpdate rowu : rows) {
            ArrayList<String> keys = new ArrayList<String>(rowu.keys);
            if (keys.isEmpty()) continue;
            HashSet<String> deltas = new HashSet<String>();
            ListIterator<String> it = keys.listIterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                Serializable value = rowu.row.get(key);
                if (!(value instanceof Delta)) continue;
                deltas.add(key);
                it.set(key + '+');
            }
            Collections.sort(keys);
            String ck = StringUtils.join(keys, (char)',');
            LinkedList<RowMapper.RowUpdate> keysUpdates = (LinkedList<RowMapper.RowUpdate>)updatesByCanonKeys.get(ck);
            if (keysUpdates == null) {
                keysUpdates = new LinkedList<RowMapper.RowUpdate>();
                updatesByCanonKeys.put(ck, keysUpdates);
                keysByCanonKeys.put(ck, rowu.keys);
                deltasByCanonKeys.put(ck, deltas);
            }
            keysUpdates.add(rowu);
        }
        for (String ck : updatesByCanonKeys.keySet()) {
            List keysUpdates = (List)updatesByCanonKeys.get(ck);
            Collection keys = (Collection)keysByCanonKeys.get(ck);
            Set deltas = (Set)deltasByCanonKeys.get(ck);
            SQLInfo.SQLInfoSelect update = this.sqlInfo.getUpdateById(tableName, keys, deltas);
            String loggedSql = this.supportsBatchUpdates && rows.size() > 1 ? update.sql + " -- BATCHED" : update.sql;
            try {
                PreparedStatement ps = this.connection.prepareStatement(update.sql);
                int batch = 0;
                try {
                    for (RowMapper.RowUpdate rowu : keysUpdates) {
                        ++batch;
                        if (this.logger.isLogEnabled()) {
                            this.logger.logSQL(loggedSql, update.whatColumns, rowu.row, deltas);
                        }
                        int i = 1;
                        for (Column column : update.whatColumns) {
                            Serializable value = rowu.row.get(column.getKey());
                            if (value instanceof Delta) {
                                value = ((Delta)value).getDeltaValue();
                            }
                            column.setToPreparedStatement(ps, i++, value);
                        }
                        if (this.supportsBatchUpdates) {
                            ps.addBatch();
                            if (batch % 100 != 0) continue;
                            int[] counts = ps.executeBatch();
                            this.countExecute();
                            this.logger.logCounts(counts);
                            continue;
                        }
                        int count = ps.executeUpdate();
                        this.countExecute();
                        this.logger.logCount(count);
                    }
                    if (!this.supportsBatchUpdates) continue;
                    int[] counts = ps.executeBatch();
                    this.countExecute();
                    this.logger.logCounts(counts);
                }
                finally {
                    this.closeStatement(ps);
                }
            }
            catch (SQLException e) {
                this.checkConnectionReset(e);
                throw new StorageException("Could not update: " + update.sql, e);
            }
        }
    }

    protected void updateCollectionRows(String tableName, List<RowMapper.RowUpdate> rowus) throws StorageException {
        HashSet<Serializable> ids = new HashSet<Serializable>(rowus.size());
        ArrayList<Row> rows = new ArrayList<Row>(rowus.size());
        for (RowMapper.RowUpdate rowu : rowus) {
            ids.add(rowu.row.id);
            rows.add(rowu.row);
        }
        this.deleteRows(tableName, ids);
        this.insertCollectionRows(tableName, rows);
    }

    protected void deleteRows(String tableName, Set<Serializable> ids) throws StorageException {
        int chunkSize;
        if (ids.isEmpty()) {
            return;
        }
        int size = ids.size();
        if (size > (chunkSize = this.sqlInfo.getMaximumArgsForIn())) {
            ArrayList<Serializable> idList = new ArrayList<Serializable>(ids);
            for (int start = 0; start < size; start += chunkSize) {
                int end = start + chunkSize;
                if (end > size) {
                    end = size;
                }
                ArrayList<Serializable> chunkIds = new ArrayList<Serializable>(idList.subList(start, end));
                this.deleteRowsDirect(tableName, chunkIds);
            }
        } else {
            this.deleteRowsDirect(tableName, ids);
        }
    }

    protected void deleteRowsSoft(List<RowMapper.NodeInfo> nodeInfos) throws StorageException {
        try {
            int size = nodeInfos.size();
            ArrayList<Serializable> ids = new ArrayList<Serializable>(size);
            for (RowMapper.NodeInfo info : nodeInfos) {
                ids.add(info.id);
            }
            int chunkSize = 100;
            if (size <= chunkSize) {
                this.doSoftDeleteRows(ids);
            } else {
                int start = 0;
                while (start < size) {
                    int end = start + chunkSize;
                    if (end > size) {
                        end = size;
                    }
                    this.doSoftDeleteRows(ids.subList(start, end));
                    start = end;
                }
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not soft delete", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSoftDeleteRows(List<Serializable> ids) throws SQLException {
        Serializable whereIds = this.newIdArray(ids);
        Calendar now = Calendar.getInstance();
        String sql = this.sqlInfo.getSoftDeleteSql();
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Arrays.asList(whereIds, now));
        }
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            this.setToPreparedStatementIdArray(ps, 1, whereIds);
            this.dialect.setToPreparedStatementTimestamp(ps, 2, now, null);
            ps.execute();
            this.countExecute();
            return;
        }
        finally {
            this.closeStatement(ps);
        }
    }

    protected Serializable newIdArray(Collection<Serializable> ids) {
        if (this.dialect.supportsArrays()) {
            return ids.toArray();
        }
        StringBuilder b = new StringBuilder();
        for (Serializable id : ids) {
            b.append(id);
            b.append('|');
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }

    protected void setToPreparedStatementIdArray(PreparedStatement ps, int index, Serializable idArray) throws SQLException {
        if (idArray instanceof String) {
            ps.setString(index, (String)((Object)idArray));
        } else {
            Array array = this.dialect.createArrayOf(1111, (Object[])idArray, this.connection);
            ps.setArray(index, array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int cleanupDeletedRows(int max, Calendar beforeTime) throws StorageException {
        if (max < 0) {
            max = 0;
        }
        String sql = this.sqlInfo.getSoftDeleteCleanupSql();
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Arrays.asList(beforeTime, Long.valueOf(max)));
        }
        try {
            if (sql.startsWith("{")) {
                boolean outFirst = sql.startsWith("{?=");
                int outIndex = outFirst ? 1 : 3;
                int inIndex = outFirst ? 2 : 1;
                try (CallableStatement cs = this.connection.prepareCall(sql);){
                    cs.setInt(inIndex, max);
                    this.dialect.setToPreparedStatementTimestamp(cs, inIndex + 1, beforeTime, null);
                    cs.registerOutParameter(outIndex, 4);
                    cs.execute();
                    int count = cs.getInt(outIndex);
                    this.logger.logCount(count);
                    int n = count;
                    return n;
                }
            }
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                ps.setInt(1, max);
                this.dialect.setToPreparedStatementTimestamp(ps, 2, beforeTime, null);
                ResultSet rs = ps.executeQuery();
                this.countExecute();
                if (!rs.next()) {
                    throw new StorageException("Cannot get result");
                }
                int count = rs.getInt(1);
                this.logger.logCount(count);
                int n = count;
                return n;
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not purge soft delete", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteRowsDirect(String tableName, Collection<Serializable> ids) throws StorageException {
        try {
            String sql = this.sqlInfo.getDeleteSql(tableName, ids.size());
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, ids);
            }
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                int i = 1;
                for (Serializable id : ids) {
                    this.dialect.setId(ps, i++, id);
                }
                int count = ps.executeUpdate();
                this.countExecute();
                this.logger.logCount(count);
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            this.checkConcurrentUpdate(e);
            throw new StorageException("Could not delete: " + tableName, e);
        }
    }

    @Override
    public Row readSimpleRow(RowId rowId) throws StorageException {
        SQLInfo.SQLInfoSelect select = this.sqlInfo.selectFragmentById.get(rowId.tableName);
        Map<String, Serializable> criteriaMap = Collections.singletonMap("id", rowId.id);
        List<Row> maps = this.getSelectRows(rowId.tableName, select, criteriaMap, null, true);
        return maps.isEmpty() ? null : maps.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getBinaryFulltext(RowId rowId) throws StorageException {
        ArrayList<String> columns = new ArrayList<String>();
        for (String index : this.model.getFulltextConfiguration().indexesAllBinary) {
            String col = "binarytext" + this.model.getFulltextIndexSuffix(index);
            columns.add(col);
        }
        Serializable id = rowId.id;
        HashMap<String, String> ret = new HashMap<String, String>(columns.size());
        String sql = this.dialect.getBinaryFulltextSql(columns);
        if (sql == null) {
            this.logger.info("getBinaryFulltextSql not supported for dialect " + this.dialect);
            return ret;
        }
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Collections.singletonList(id));
        }
        try {
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                this.dialect.setId(ps, 1, id);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    for (int i = 1; i <= columns.size(); ++i) {
                        ret.put(columns.get(i - 1), rs.getString(i));
                    }
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.log("  -> " + ret);
                }
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not select: " + sql, e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable[] readCollectionRowArray(RowId rowId) throws StorageException {
        Serializable[] serializableArray;
        String tableName = rowId.tableName;
        Serializable id = rowId.id;
        String sql = this.sqlInfo.selectFragmentById.get((Object)tableName).sql;
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Collections.singletonList(id));
        }
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            List<Column> columns = this.sqlInfo.selectFragmentById.get((Object)tableName).whatColumns;
            this.dialect.setId(ps, 1, id);
            ResultSet rs = ps.executeQuery();
            this.countExecute();
            CollectionIO io = this.getCollectionIO(tableName);
            ArrayList<Serializable> list = new ArrayList<Serializable>();
            Serializable[] returnId = new Serializable[1];
            int[] returnPos = new int[]{-1};
            while (rs.next()) {
                list.add(io.getCurrentFromResultSet(rs, columns, this.model, returnId, returnPos));
            }
            PropertyType type = this.model.getCollectionFragmentType(tableName).getArrayBaseType();
            Serializable[] array = type.collectionToArray(list);
            if (this.logger.isLogEnabled()) {
                this.logger.log("  -> " + Arrays.asList(array));
            }
            serializableArray = array;
        }
        catch (Throwable throwable) {
            try {
                this.closeStatement(ps);
                throw throwable;
            }
            catch (SQLException e) {
                this.checkConnectionReset(e);
                throw new StorageException("Could not select: " + sql, e);
            }
        }
        this.closeStatement(ps);
        return serializableArray;
    }

    @Override
    public List<Row> readSelectionRows(SelectionType selType, Serializable selId, Serializable filter, Serializable criterion, boolean limitToOne) throws StorageException {
        SQLInfo.SQLInfoSelect select;
        SQLInfo.SQLInfoSelection selInfo = this.sqlInfo.getSelection(selType);
        HashMap<String, Serializable> criteriaMap = new HashMap<String, Serializable>();
        criteriaMap.put(selType.selKey, selId);
        if (filter == null) {
            select = selInfo.selectAll;
        } else {
            select = selInfo.selectFiltered;
            criteriaMap.put(selType.filterKey, filter);
        }
        if (selType.criterionKey != null) {
            criteriaMap.put(selType.criterionKey, criterion);
        }
        return this.getSelectRows(selType.tableName, select, criteriaMap, null, limitToOne);
    }

    @Override
    public RowMapper.CopyResult copy(RowMapper.IdWithTypes source, Serializable destParentId, String destName, Row overwriteRow) throws StorageException {
        Invalidations invalidations = new Invalidations();
        try {
            Serializable invalParentId;
            Serializable overwriteId;
            LinkedHashMap<Serializable, Serializable> idMap = new LinkedHashMap<Serializable, Serializable>();
            HashMap<Serializable, RowMapper.IdWithTypes> idToTypes = new HashMap<Serializable, RowMapper.IdWithTypes>();
            Serializable serializable = overwriteId = overwriteRow == null ? null : overwriteRow.id;
            if (overwriteId != null) {
                String tableName = "hierarchy";
                this.updateSimpleRowWithValues(tableName, overwriteRow);
                idMap.put(source.id, overwriteId);
                invalidations.addModified(new RowId(tableName, overwriteId));
            }
            boolean resetVersion = destParentId != null;
            Serializable newRootId = this.copyHierRecursive(source, destParentId, destName, overwriteId, resetVersion, idMap, idToTypes);
            Serializable serializable2 = invalParentId = overwriteId == null ? destParentId : overwriteId;
            if (invalParentId != null) {
                invalidations.addModified(new RowId("__PARENT__", invalParentId));
            }
            HashSet<Serializable> proxyIds = new HashSet<Serializable>();
            for (Map.Entry<String, Set<Serializable>> entry : this.model.getPerFragmentIds(idToTypes).entrySet()) {
                Boolean invalidation;
                String tableName = entry.getKey();
                if (tableName.equals("hierarchy")) continue;
                if (tableName.equals("versions")) continue;
                Set<Serializable> ids = entry.getValue();
                if (tableName.equals("proxies")) {
                    for (Serializable id : ids) {
                        proxyIds.add((Serializable)idMap.get(id));
                    }
                }
                if ((invalidation = this.copyRows(tableName, ids, idMap, overwriteId)) == null) continue;
                if (Boolean.TRUE.equals(invalidation)) {
                    invalidations.addModified(new RowId(tableName, overwriteId));
                    continue;
                }
                invalidations.addDeleted(new RowId(tableName, overwriteId));
            }
            return new RowMapper.CopyResult(newRootId, invalidations, proxyIds);
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not copy: " + source.id.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSimpleRowWithValues(String tableName, Row row) throws StorageException {
        Update update = this.sqlInfo.getUpdateByIdForKeys(tableName, row.getKeys());
        Table table = update.getTable();
        String sql = update.getStatement();
        try {
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                if (this.logger.isLogEnabled()) {
                    LinkedList<Serializable> values = new LinkedList<Serializable>();
                    values.addAll(row.getValues());
                    values.add(row.id);
                    this.logger.logSQL(sql, values);
                }
                int i = 1;
                List<String> keys = row.getKeys();
                List<Serializable> values = row.getValues();
                int size = keys.size();
                for (int r = 0; r < size; ++r) {
                    String key = keys.get(r);
                    Serializable value = values.get(r);
                    table.getColumn(key).setToPreparedStatement(ps, i++, value);
                }
                this.dialect.setId(ps, i, row.id);
                int count = ps.executeUpdate();
                this.countExecute();
                this.logger.logCount(count);
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not update: " + sql, e);
        }
    }

    protected Serializable copyHierRecursive(RowMapper.IdWithTypes source, Serializable parentId, String name, Serializable overwriteId, boolean resetVersion, Map<Serializable, Serializable> idMap, Map<Serializable, RowMapper.IdWithTypes> idToTypes) throws SQLException {
        Serializable newId;
        idToTypes.put(source.id, source);
        if (overwriteId == null) {
            newId = this.copyHier(source.id, parentId, name, resetVersion, idMap);
        } else {
            newId = overwriteId;
            idMap.put(source.id, newId);
        }
        boolean onlyComplex = parentId == null;
        for (RowMapper.IdWithTypes child : this.getChildrenIdsWithTypes(source.id, onlyComplex)) {
            this.copyHierRecursive(child, newId, null, null, resetVersion, idMap, idToTypes);
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Serializable copyHier(Serializable id, Serializable parentId, String name, boolean resetVersion, Map<Serializable, Serializable> idMap) throws SQLException {
        explicitName = name != null;
        copy = this.sqlInfo.getCopyHier(explicitName, resetVersion);
        ps = this.connection.prepareStatement(copy.sql);
        try {
            newId = this.generateNewIdInternal();
            debugValues = null;
            if (this.logger.isLogEnabled()) {
                debugValues = new ArrayList<Serializable>(4);
            }
            i = 1;
            for (Column column : copy.whatColumns) {
                block12: {
                    block14: {
                        block13: {
                            block11: {
                                key = column.getKey();
                                if (!key.equals("parentid")) break block11;
                                v = parentId;
                                break block12;
                            }
                            if (!key.equals("name")) break block13;
                            v = name;
                            break block12;
                        }
                        if (!key.equals("id")) break block14;
                        v = newId;
                        break block12;
                    }
                    if (key.equals("baseversionid")) ** GOTO lbl-1000
                    if (key.equals("ischeckedin")) lbl-1000:
                    // 2 sources

                    {
                        v = null;
                    } else {
                        if (!key.equals("minorversion")) {
                            if (!key.equals("majorversion")) {
                                throw new RuntimeException(column.toString());
                            }
                        }
                        v = null;
                    }
                }
                column.setToPreparedStatement(ps, i++, (Serializable)v);
                if (debugValues == null) continue;
                debugValues.add((Serializable)v);
            }
            whereColumn = copy.whereColumns.get(0);
            whereColumn.setToPreparedStatement(ps, i, id);
            if (debugValues != null) {
                debugValues.add(id);
                this.logger.logSQL(copy.sql, debugValues);
            }
            count = ps.executeUpdate();
            this.countExecute();
            this.logger.logCount(count);
            idMap.put(id, newId);
            var14_15 = newId;
            return var14_15;
        }
        finally {
            this.closeStatement(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<RowMapper.IdWithTypes> getChildrenIdsWithTypes(Serializable id, boolean onlyComplex) throws SQLException {
        LinkedList<RowMapper.IdWithTypes> children = new LinkedList<RowMapper.IdWithTypes>();
        String sql = this.sqlInfo.getSelectChildrenIdsAndTypesSql(onlyComplex);
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Collections.singletonList(id));
        }
        List<Column> columns = this.sqlInfo.getSelectChildrenIdsAndTypesWhatColumns();
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            LinkedList<String> debugValues = null;
            if (this.logger.isLogEnabled()) {
                debugValues = new LinkedList<String>();
            }
            this.dialect.setId(ps, 1, id);
            ResultSet rs = ps.executeQuery();
            this.countExecute();
            while (rs.next()) {
                Serializable childId = null;
                String childPrimaryType = null;
                String[] childMixinTypes = null;
                int i = 1;
                for (Column column : columns) {
                    String key = column.getKey();
                    Serializable value = column.getFromResultSet(rs, i++);
                    if (key.equals("id")) {
                        childId = value;
                        continue;
                    }
                    if (key.equals("primarytype")) {
                        childPrimaryType = (String)((Object)value);
                        continue;
                    }
                    if (!key.equals("mixintypes")) continue;
                    childMixinTypes = (String[])value;
                }
                children.add(new RowMapper.IdWithTypes(childId, childPrimaryType, childMixinTypes));
                if (debugValues == null) continue;
                debugValues.add(childId + "/" + childPrimaryType + "/" + Arrays.toString(childMixinTypes));
            }
            if (debugValues != null) {
                this.logger.log("  -> " + debugValues);
            }
            LinkedList<RowMapper.IdWithTypes> linkedList = children;
            return linkedList;
        }
        finally {
            this.closeStatement(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean copyRows(String tableName, Set<Serializable> ids, Map<Serializable, Serializable> idMap, Serializable overwriteId) throws SQLException {
        String copySql = this.sqlInfo.getCopySql(tableName);
        Column copyIdColumn = this.sqlInfo.getCopyIdColumn(tableName);
        PreparedStatement copyPs = this.connection.prepareStatement(copySql);
        String deleteSql = this.sqlInfo.getDeleteSql(tableName);
        PreparedStatement deletePs = this.connection.prepareStatement(deleteSql);
        try {
            boolean before = false;
            boolean after = false;
            for (Serializable id : ids) {
                Serializable newId = idMap.get(id);
                boolean overwrite = newId.equals(overwriteId);
                if (overwrite) {
                    if (this.logger.isLogEnabled()) {
                        this.logger.logSQL(deleteSql, Collections.singletonList(newId));
                    }
                    this.dialect.setId(deletePs, 1, newId);
                    int delCount = deletePs.executeUpdate();
                    this.countExecute();
                    this.logger.logCount(delCount);
                    before = delCount > 0;
                }
                copyIdColumn.setToPreparedStatement(copyPs, 1, newId);
                copyIdColumn.setToPreparedStatement(copyPs, 2, id);
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL(copySql, Arrays.asList(newId, id));
                }
                int copyCount = copyPs.executeUpdate();
                this.countExecute();
                this.logger.logCount(copyCount);
                if (!overwrite) continue;
                after = copyCount > 0;
            }
            Boolean bl = after ? Boolean.TRUE : (before ? Boolean.FALSE : null);
            return bl;
        }
        finally {
            this.closeStatement(copyPs);
            this.closeStatement(deletePs);
        }
    }

    @Override
    public List<RowMapper.NodeInfo> remove(RowMapper.NodeInfo rootInfo) throws StorageException {
        Serializable rootId = rootInfo.id;
        List<RowMapper.NodeInfo> info = this.getDescendantsInfo(rootId);
        info.add(rootInfo);
        if (this.sqlInfo.softDeleteEnabled) {
            this.deleteRowsSoft(info);
        } else {
            this.deleteRowsDirect("hierarchy", Collections.singleton(rootId));
        }
        return info;
    }

    protected List<RowMapper.NodeInfo> getDescendantsInfo(Serializable rootId) throws StorageException {
        LinkedList<RowMapper.NodeInfo> descendants = new LinkedList<RowMapper.NodeInfo>();
        String sql = this.sqlInfo.getSelectDescendantsInfoSql();
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Collections.singletonList(rootId));
        }
        List<Column> columns = this.sqlInfo.getSelectDescendantsInfoWhatColumns();
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(sql);
            LinkedList<String> debugValues = null;
            if (this.logger.isLogEnabled()) {
                debugValues = new LinkedList<String>();
            }
            this.dialect.setId(ps, 1, rootId);
            ResultSet rs = ps.executeQuery();
            this.countExecute();
            while (rs.next()) {
                Serializable id = null;
                Serializable parentId = null;
                String primaryType = null;
                Boolean isProperty = null;
                Serializable targetId = null;
                Serializable versionableId = null;
                int i = 1;
                for (Column column : columns) {
                    String key = column.getKey();
                    Serializable value = column.getFromResultSet(rs, i++);
                    if (key.equals("id")) {
                        id = value;
                        continue;
                    }
                    if (key.equals("parentid")) {
                        parentId = value;
                        continue;
                    }
                    if (key.equals("primarytype")) {
                        primaryType = (String)((Object)value);
                        continue;
                    }
                    if (key.equals("isproperty")) {
                        isProperty = (Boolean)value;
                        continue;
                    }
                    if (key.equals("targetid")) {
                        targetId = value;
                        continue;
                    }
                    if (!key.equals("versionableid")) continue;
                    versionableId = value;
                }
                descendants.add(new RowMapper.NodeInfo(id, parentId, primaryType, isProperty, versionableId, targetId));
                if (debugValues == null || debugValues.size() >= 50) continue;
                debugValues.add(id + "/" + primaryType);
            }
            if (debugValues != null) {
                if (debugValues.size() >= 50) {
                    debugValues.add("... (" + descendants.size() + ") results");
                }
                this.logger.log("  -> " + debugValues);
            }
            LinkedList<RowMapper.NodeInfo> linkedList = descendants;
            return linkedList;
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Failed to get descendants", e);
        }
        finally {
            if (ps != null) {
                try {
                    this.closeStatement(ps);
                }
                catch (SQLException e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
        }
    }
}

