/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.Serializable;
import java.net.SocketException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.core.storage.FulltextConfiguration;
import org.nuxeo.ecm.core.storage.FulltextQueryAnalyzer;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.binary.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.TableAlias;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class DialectPostgreSQL
extends Dialect {
    private static final Log log = LogFactory.getLog(DialectPostgreSQL.class);
    private static final String DEFAULT_FULLTEXT_ANALYZER = "english";
    private static final String DEFAULT_USERS_SEPARATOR = ",";
    private static final String PREFIX_SEARCH = ":*";
    private static final Pattern PREFIX_PATTERN = Pattern.compile("(\\*|%|:\\*)( |\"|$)");
    private static final String PREFIX_REPL = ":*$2";
    private static final String[] RESERVED_COLUMN_NAMES = new String[]{"xmin", "xmax", "cmin", "cmax", "ctid", "oid", "tableoid"};
    private static final String UNLOGGED_KEYWORD = "UNLOGGED";
    protected final String fulltextAnalyzer;
    protected final boolean supportsWith;
    protected boolean hierarchyCreated;
    protected boolean pathOptimizationsEnabled;
    protected String usersSeparator;
    protected final Dialect.DialectIdType idType;
    protected boolean compatibilityFulltextTable;
    protected final String unloggedKeyword;
    protected String idSequenceName;
    protected static final String FT_LIKE_SEP = " @#AND#@ ";
    protected static final String FT_LIKE_COL = "??";

    public DialectPostgreSQL(DatabaseMetaData metadata, BinaryManager binaryManager, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, binaryManager, repositoryDescriptor);
        String idt;
        int minor;
        int major;
        this.fulltextAnalyzer = repositoryDescriptor == null ? null : (repositoryDescriptor.fulltextAnalyzer == null ? DEFAULT_FULLTEXT_ANALYZER : repositoryDescriptor.fulltextAnalyzer);
        this.pathOptimizationsEnabled = repositoryDescriptor == null ? false : repositoryDescriptor.getPathOptimizationsEnabled();
        try {
            major = metadata.getDatabaseMajorVersion();
            minor = metadata.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
        this.supportsWith = major > 8 || major == 8 && minor >= 4;
        this.unloggedKeyword = major == 9 && minor >= 1 || major > 9 ? UNLOGGED_KEYWORD : "";
        this.usersSeparator = repositoryDescriptor == null ? null : (repositoryDescriptor.usersSeparatorKey == null ? DEFAULT_USERS_SEPARATOR : repositoryDescriptor.usersSeparatorKey);
        String string = idt = repositoryDescriptor == null ? null : repositoryDescriptor.idType;
        if (idt == null || "".equals(idt) || "varchar".equalsIgnoreCase(idt)) {
            this.idType = Dialect.DialectIdType.VARCHAR;
        } else if ("uuid".equalsIgnoreCase(idt)) {
            this.idType = Dialect.DialectIdType.UUID;
        } else if (idt.toLowerCase().startsWith("sequence")) {
            this.idType = Dialect.DialectIdType.SEQUENCE;
            if (idt.toLowerCase().startsWith("sequence:")) {
                String[] split = idt.split(":");
                this.idSequenceName = split[1];
            } else {
                this.idSequenceName = "hierarchy_seq";
            }
        } else {
            throw new StorageException("Unknown id type: '" + idt + "'");
        }
        try {
            this.compatibilityFulltextTable = this.getCompatibilityFulltextTable(metadata);
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    protected boolean getCompatibilityFulltextTable(DatabaseMetaData metadata) throws SQLException {
        ResultSet rs = metadata.getColumns(null, null, "fulltext", "%");
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            if (!"fulltext".equals(columnName)) continue;
            String typeName = rs.getString("TYPE_NAME");
            return "tsvector".equals(typeName);
        }
        return false;
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        return bool ? "true" : "false";
    }

    @Override
    public String getNoColumnsInsertString() {
        return "DEFAULT VALUES";
    }

    @Override
    public String getCascadeDropConstraintsString() {
        return "CASCADE";
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type.spec) {
            case STRING: {
                if (type.isUnconstrained()) {
                    return DialectPostgreSQL.jdbcInfo("varchar", 12);
                }
                if (type.isClob()) {
                    return DialectPostgreSQL.jdbcInfo("text", 2005);
                }
                return DialectPostgreSQL.jdbcInfo("varchar(%d)", type.length, 12);
            }
            case ARRAY_STRING: {
                if (type.isUnconstrained()) {
                    return DialectPostgreSQL.jdbcInfo("varchar[]", 2003, "varchar", 12);
                }
                if (type.isClob()) {
                    return DialectPostgreSQL.jdbcInfo("text[]", 2003, "text", 2005);
                }
                return DialectPostgreSQL.jdbcInfo("varchar(%d)[]", type.length, 2003, "varchar", 12);
            }
            case BOOLEAN: {
                return DialectPostgreSQL.jdbcInfo("bool", -7);
            }
            case ARRAY_BOOLEAN: {
                return DialectPostgreSQL.jdbcInfo("bool[]", 2003, "bool", 16);
            }
            case LONG: {
                return DialectPostgreSQL.jdbcInfo("int8", -5);
            }
            case ARRAY_LONG: {
                return DialectPostgreSQL.jdbcInfo("int8[]", 2003, "int8", -5);
            }
            case DOUBLE: {
                return DialectPostgreSQL.jdbcInfo("float8", 8);
            }
            case ARRAY_DOUBLE: {
                return DialectPostgreSQL.jdbcInfo("float8[]", 2003, "float8", 8);
            }
            case TIMESTAMP: {
                return DialectPostgreSQL.jdbcInfo("timestamp", 93);
            }
            case ARRAY_TIMESTAMP: {
                return DialectPostgreSQL.jdbcInfo("timestamp[]", 2003, "timestamp", 93);
            }
            case BLOBID: {
                return DialectPostgreSQL.jdbcInfo("varchar(40)", 12);
            }
            case ARRAY_BLOBID: {
                return DialectPostgreSQL.jdbcInfo("varchar(40)[]", 2003, "varchar", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEIDPK: 
            case NODEVAL: {
                switch (this.idType) {
                    case VARCHAR: {
                        return DialectPostgreSQL.jdbcInfo("varchar(36)", 12);
                    }
                    case UUID: {
                        return DialectPostgreSQL.jdbcInfo("uuid", 1111);
                    }
                    case SEQUENCE: {
                        return DialectPostgreSQL.jdbcInfo("int8", -5);
                    }
                }
            }
            case NODEARRAY: {
                switch (this.idType) {
                    case VARCHAR: {
                        return DialectPostgreSQL.jdbcInfo("varchar(36)[]", 2003, "varchar", 12);
                    }
                    case UUID: {
                        return DialectPostgreSQL.jdbcInfo("uuid[]", 2003, "uuid", 1111);
                    }
                    case SEQUENCE: {
                        return DialectPostgreSQL.jdbcInfo("int8[]", 2003, "int8", -5);
                    }
                }
            }
            case SYSNAME: {
                return DialectPostgreSQL.jdbcInfo("varchar(250)", 12);
            }
            case SYSNAMEARRAY: {
                return DialectPostgreSQL.jdbcInfo("varchar(250)[]", 2003, "varchar", 12);
            }
            case TINYINT: {
                return DialectPostgreSQL.jdbcInfo("int2", 5);
            }
            case INTEGER: {
                return DialectPostgreSQL.jdbcInfo("int4", 4);
            }
            case ARRAY_INTEGER: {
                return DialectPostgreSQL.jdbcInfo("int4[]", 2003, "int4", 4);
            }
            case AUTOINC: {
                return DialectPostgreSQL.jdbcInfo("serial", 4);
            }
            case FTINDEXED: {
                if (this.compatibilityFulltextTable) {
                    return DialectPostgreSQL.jdbcInfo("tsvector", 1111);
                }
                return DialectPostgreSQL.jdbcInfo("text", 2005);
            }
            case FTSTORED: {
                if (this.compatibilityFulltextTable) {
                    return DialectPostgreSQL.jdbcInfo("tsvector", 1111);
                }
                return DialectPostgreSQL.jdbcInfo("text", 2005);
            }
            case CLUSTERNODE: {
                return DialectPostgreSQL.jdbcInfo("int4", 4);
            }
            case CLUSTERFRAGS: {
                return DialectPostgreSQL.jdbcInfo("varchar[]", 2003, "varchar", 12);
            }
        }
        throw new AssertionError(type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == 2005) {
            return true;
        }
        if (expected == 2005 && actual == 12) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        if (expected == 4 && actual == -5) {
            return true;
        }
        return expected == 2005 && actual == 1111 && actualName.equals("tsvector");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable getGeneratedId(Connection connection) throws SQLException {
        if (this.idType != Dialect.DialectIdType.SEQUENCE) {
            return super.getGeneratedId(connection);
        }
        String sql = String.format("SELECT NEXTVAL('%s')", this.idSequenceName);
        try (Statement s = connection.createStatement();){
            ResultSet rs = s.executeQuery(sql);
            rs.next();
            Long l = rs.getLong(1);
            return l;
        }
    }

    @Override
    public void setId(PreparedStatement ps, int index, Serializable value) throws SQLException {
        switch (this.idType) {
            case VARCHAR: {
                ps.setObject(index, value);
                break;
            }
            case UUID: {
                ps.setObject(index, (Object)value, 1111);
                break;
            }
            case SEQUENCE: {
                this.setIdLong(ps, index, value);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public Serializable getId(ResultSet rs, int index) throws SQLException {
        switch (this.idType) {
            case VARCHAR: 
            case UUID: {
                return rs.getString(index);
            }
            case SEQUENCE: {
                return Long.valueOf(rs.getLong(index));
            }
        }
        throw new AssertionError();
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                this.setToPreparedStatementString(ps, index, (Serializable)value, column);
                return;
            }
            case -7: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case 5: {
                ps.setInt(index, ((Long)value).intValue());
                return;
            }
            case -5: 
            case 4: {
                ps.setLong(index, ((Number)value).longValue());
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                ps.setTimestamp(index, this.getTimestampFromCalendar((Calendar)value));
                return;
            }
            case 2003: {
                int jdbcBaseType = column.getJdbcBaseType();
                String jdbcBaseTypeName = column.getSqlBaseTypeString();
                if (jdbcBaseType == 93) {
                    value = this.getTimestampFromCalendar(value);
                }
                Array array = ps.getConnection().createArrayOf(jdbcBaseTypeName, value);
                ps.setArray(index, array);
                return;
            }
            case 1111: {
                ColumnType type = column.getType();
                if (type.isId()) {
                    this.setId(ps, index, (Serializable)value);
                    return;
                }
                if (type == ColumnType.FTSTORED) {
                    ps.setString(index, (String)value);
                    return;
                }
                throw new SQLException("Unhandled type: " + column.getType());
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        int jdbcType = rs.getMetaData().getColumnType(index);
        jdbcType = column.getJdbcType() == 2003 && jdbcType != 2003 ? column.getJdbcBaseType() : column.getJdbcType();
        switch (jdbcType) {
            case 12: 
            case 2005: {
                return this.getFromResultSetString(rs, index, column);
            }
            case -7: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -5: 
            case 4: 
            case 5: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                return this.getCalendarFromTimestamp(rs.getTimestamp(index));
            }
            case 2003: {
                Array array = rs.getArray(index);
                if (array == null) {
                    return null;
                }
                if (array.getBaseType() == 93) {
                    return this.getCalendarFromTimestamp((Timestamp[])array.getArray());
                }
                return (Serializable)array.getArray();
            }
            case 1111: {
                ColumnType type = column.getType();
                if (type.isId()) {
                    return this.getId(rs, index);
                }
                throw new SQLException("Unhandled type: " + column.getType());
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType() + " for type " + column.getType().toString());
    }

    @Override
    protected int getMaxNameSize() {
        return 63;
    }

    @Override
    public String getColumnName(String name) {
        String n = name.replaceAll("_+$", "");
        for (String reserved : RESERVED_COLUMN_NAMES) {
            if (!n.equals(reserved)) continue;
            name = name + "_";
            break;
        }
        return super.getColumnName(name);
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        String sql = this.compatibilityFulltextTable ? "CREATE INDEX %s ON %s USING GIN(%s)" : "CREATE INDEX %s ON %s USING GIN(NX_TO_TSVECTOR(%s))";
        return String.format(sql, quotedIndexName.toLowerCase(), table.getQuotedName(), columns.get(0).getQuotedName());
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        query = query.replace(" & ", " ");
        FulltextQueryAnalyzer.FulltextQuery ft = FulltextQueryAnalyzer.analyzeFulltextQuery((String)(query = PREFIX_PATTERN.matcher(query).replaceAll(PREFIX_REPL)));
        if (ft == null) {
            return "";
        }
        if (!FulltextQueryAnalyzer.hasPhrase((FulltextQueryAnalyzer.FulltextQuery)ft)) {
            return FulltextQueryAnalyzer.translateFulltext((FulltextQueryAnalyzer.FulltextQuery)ft, (String)"|", (String)"&", (String)"& !", (String)"");
        }
        if (this.compatibilityFulltextTable) {
            throw new QueryMaker.QueryMakerException("Cannot use phrase search in fulltext compatibilty mode. Please upgrade the fulltext table: " + query);
        }
        FulltextQueryAnalyzer.FulltextQuery broken = DialectPostgreSQL.breakPhrases(ft);
        String ftsql = FulltextQueryAnalyzer.translateFulltext((FulltextQueryAnalyzer.FulltextQuery)broken, (String)"|", (String)"&", (String)"& !", (String)"");
        FulltextQueryAnalyzer.FulltextQuery noand = DialectPostgreSQL.removeToplevelAndedWords(ft);
        if (noand != null) {
            StringBuilder buf = new StringBuilder();
            DialectPostgreSQL.generateLikeSql(noand, buf);
            ftsql = ftsql + FT_LIKE_SEP + buf.toString();
        }
        return ftsql;
    }

    protected static FulltextQueryAnalyzer.FulltextQuery breakPhrases(FulltextQueryAnalyzer.FulltextQuery ft) {
        FulltextQueryAnalyzer.FulltextQuery newFt = new FulltextQueryAnalyzer.FulltextQuery();
        if (ft.op == FulltextQueryAnalyzer.Op.AND || ft.op == FulltextQueryAnalyzer.Op.OR) {
            LinkedList<FulltextQueryAnalyzer.FulltextQuery> newTerms = new LinkedList<FulltextQueryAnalyzer.FulltextQuery>();
            for (FulltextQueryAnalyzer.FulltextQuery term : ft.terms) {
                FulltextQueryAnalyzer.FulltextQuery broken = DialectPostgreSQL.breakPhrases(term);
                if (broken == null) continue;
                if (ft.op == FulltextQueryAnalyzer.Op.AND && broken.op == FulltextQueryAnalyzer.Op.AND) {
                    newTerms.addAll(broken.terms);
                    continue;
                }
                newTerms.add(broken);
            }
            if (newTerms.size() == 1) {
                newFt = (FulltextQueryAnalyzer.FulltextQuery)newTerms.get(0);
            } else {
                newFt.op = ft.op;
                newFt.terms = newTerms;
            }
        } else {
            boolean isPhrase = ft.isPhrase();
            if (!isPhrase) {
                newFt = ft;
            } else if (ft.op == FulltextQueryAnalyzer.Op.WORD) {
                LinkedList<FulltextQueryAnalyzer.FulltextQuery> newTerms = new LinkedList<FulltextQueryAnalyzer.FulltextQuery>();
                for (String subword : ft.word.split(" ")) {
                    FulltextQueryAnalyzer.FulltextQuery sft = new FulltextQueryAnalyzer.FulltextQuery();
                    sft.op = FulltextQueryAnalyzer.Op.WORD;
                    sft.word = subword;
                    newTerms.add(sft);
                }
                newFt.op = FulltextQueryAnalyzer.Op.AND;
                newFt.terms = newTerms;
            } else {
                newFt = null;
            }
        }
        return newFt;
    }

    protected static FulltextQueryAnalyzer.FulltextQuery removeToplevelAndedWords(FulltextQueryAnalyzer.FulltextQuery ft) {
        if (ft.op == FulltextQueryAnalyzer.Op.OR || ft.op == FulltextQueryAnalyzer.Op.NOTWORD) {
            return ft;
        }
        if (ft.op == FulltextQueryAnalyzer.Op.WORD) {
            if (ft.isPhrase()) {
                return ft;
            }
            return null;
        }
        LinkedList<FulltextQueryAnalyzer.FulltextQuery> newTerms = new LinkedList<FulltextQueryAnalyzer.FulltextQuery>();
        for (FulltextQueryAnalyzer.FulltextQuery term : ft.terms) {
            if (term.op == FulltextQueryAnalyzer.Op.NOTWORD) {
                newTerms.add(term);
                continue;
            }
            if (!term.isPhrase()) continue;
            newTerms.add(term);
        }
        if (newTerms.isEmpty()) {
            return null;
        }
        if (newTerms.size() == 1) {
            return (FulltextQueryAnalyzer.FulltextQuery)newTerms.get(0);
        }
        FulltextQueryAnalyzer.FulltextQuery newFt = new FulltextQueryAnalyzer.FulltextQuery();
        newFt.op = FulltextQueryAnalyzer.Op.AND;
        newFt.terms = newTerms;
        return newFt;
    }

    protected static void generateLikeSql(FulltextQueryAnalyzer.FulltextQuery ft, StringBuilder buf) {
        if (ft.op == FulltextQueryAnalyzer.Op.AND || ft.op == FulltextQueryAnalyzer.Op.OR) {
            buf.append('(');
            boolean first = true;
            for (FulltextQueryAnalyzer.FulltextQuery term : ft.terms) {
                if (!first) {
                    if (ft.op == FulltextQueryAnalyzer.Op.AND) {
                        buf.append(" AND ");
                    } else {
                        buf.append(" OR ");
                    }
                }
                first = false;
                DialectPostgreSQL.generateLikeSql(term, buf);
            }
            buf.append(')');
        } else {
            buf.append(FT_LIKE_COL);
            if (ft.op == FulltextQueryAnalyzer.Op.NOTWORD) {
                buf.append(" NOT");
            }
            buf.append(" LIKE '% ");
            String word = ft.word.toLowerCase();
            word = word.replace("'", "''");
            word = word.replace("\\", "");
            word = word.replace(PREFIX_SEARCH, "%");
            buf.append(word);
            if (!word.endsWith("%")) {
                buf.append(" %");
            }
            buf.append("'");
        }
    }

    @Override
    public Dialect.FulltextMatchInfo getFulltextScoredMatchInfo(String fulltextQuery, String indexName, int nthMatch, Column mainColumn, Model model, Database database) {
        String like;
        String indexSuffix = model.getFulltextIndexSuffix(indexName);
        Table ft = database.getTable("fulltext");
        Column ftMain = ft.getColumn("id");
        Column ftColumn = ft.getColumn("fulltext" + indexSuffix);
        String ftColumnName = ftColumn.getFullQuotedName();
        String nthSuffix = nthMatch == 1 ? "" : String.valueOf(nthMatch);
        Dialect.FulltextMatchInfo info = new Dialect.FulltextMatchInfo();
        info.joins = new ArrayList<Join>();
        if (nthMatch == 1) {
            info.joins.add(new Join(1, ft.getQuotedName(), null, null, ftMain.getFullQuotedName(), mainColumn.getFullQuotedName()));
        }
        if (fulltextQuery.contains(FT_LIKE_SEP)) {
            String[] tmp = fulltextQuery.split(FT_LIKE_SEP, 2);
            fulltextQuery = tmp[0];
            like = tmp[1].replace(FT_LIKE_COL, ftColumnName);
        } else {
            like = null;
        }
        String tsquery = String.format("TO_TSQUERY('%s', ?)", this.fulltextAnalyzer);
        String tsvector = this.compatibilityFulltextTable ? ftColumnName : String.format("NX_TO_TSVECTOR(%s)", ftColumnName);
        String where = String.format("(%s @@ %s)", tsquery, tsvector);
        if (like != null) {
            where = where + " AND (" + like + ")";
        }
        info.whereExpr = where;
        info.whereExprParam = fulltextQuery;
        info.scoreExpr = String.format("TS_RANK_CD(%s, %s, 32)", tsvector, tsquery);
        info.scoreExprParam = fulltextQuery;
        info.scoreAlias = "_nxscore" + nthSuffix;
        info.scoreCol = new Column(mainColumn.getTable(), null, ColumnType.DOUBLE, null);
        return info;
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return true;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 1;
    }

    @Override
    public String getFreeVariableSetterForType(ColumnType type) {
        if (type == ColumnType.FTSTORED && this.compatibilityFulltextTable) {
            return "NX_TO_TSVECTOR(?)";
        }
        return "?";
    }

    @Override
    public boolean supportsUpdateFrom() {
        return true;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        return false;
    }

    @Override
    public boolean needsAliasForDerivedTable() {
        return true;
    }

    @Override
    public boolean supportsIlike() {
        return true;
    }

    @Override
    public boolean supportsReadAcl() {
        return this.aclOptimizationsEnabled;
    }

    @Override
    public String getPrepareUserReadAclsSql() {
        return "SELECT nx_prepare_user_read_acls(?)";
    }

    @Override
    public String getReadAclsCheckSql(String userIdCol) {
        return String.format("%s = md5(array_to_string(?, '%s'))", userIdCol, this.getUsersSeparator());
    }

    @Override
    public String getUpdateReadAclsSql() {
        return "SELECT nx_update_read_acls();";
    }

    @Override
    public String getRebuildReadAclsSql() {
        return "SELECT nx_rebuild_read_acls();";
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED(%s, ?, ?)", idColumnName);
    }

    @Override
    public boolean supportsAncestorsTable() {
        return true;
    }

    @Override
    public String getInTreeSql(String idColumnName) {
        if (this.pathOptimizationsEnabled) {
            String cast = this.idType == Dialect.DialectIdType.UUID ? "::uuid[]" : "";
            return String.format("EXISTS(SELECT 1 FROM ancestors WHERE id = %s AND ARRAY[?]%s <@ ancestors)", idColumnName, cast);
        }
        return String.format("%s IN (SELECT * FROM nx_children(?))", idColumnName);
    }

    @Override
    public String getMatchMixinType(Column mixinsColumn, String mixin, boolean positive, String[] returnParam) {
        returnParam[0] = mixin;
        String sql = "ARRAY[?]::varchar[] <@ " + mixinsColumn.getFullQuotedName();
        return positive ? sql : "NOT(" + sql + ")";
    }

    @Override
    public boolean supportsSysNameArray() {
        return true;
    }

    @Override
    public boolean supportsArrays() {
        return true;
    }

    @Override
    public boolean supportsArrayColumns() {
        return true;
    }

    @Override
    public Dialect.ArraySubQuery getArraySubQuery(Column arrayColumn, String subQueryAlias) throws QueryMaker.QueryMakerException {
        return new ArraySubQueryPostgreSQL(arrayColumn, subQueryAlias);
    }

    @Override
    public String getArrayElementString(String arrayColumnName, int arrayElementIndex) throws QueryMaker.QueryMakerException {
        return arrayColumnName + "[" + (arrayElementIndex + 1) + "]";
    }

    @Override
    public String getArrayInSql(Column arrayColumn, String cast, boolean positive, List<Serializable> params) {
        StringBuilder sql = new StringBuilder();
        if (!positive) {
            sql.append("(NOT(");
        }
        if (params.size() == 1) {
            sql.append("? = ANY(");
            sql.append(arrayColumn.getFullQuotedName());
            if (cast != null) {
                sql.append("::");
                sql.append(cast);
                sql.append("[]");
            }
            sql.append(")");
        } else {
            sql.append(arrayColumn.getFullQuotedName());
            sql.append(" && ");
            sql.append("ARRAY[");
            for (int i = 0; i < params.size(); ++i) {
                if (i != 0) {
                    sql.append(", ");
                }
                sql.append('?');
            }
            sql.append("]::");
            sql.append(arrayColumn.getSqlTypeString());
        }
        if (!positive) {
            sql.append(") OR ");
            sql.append(arrayColumn.getFullQuotedName());
            sql.append(" IS NULL)");
        }
        return sql.toString();
    }

    @Override
    public String getArrayLikeSql(Column arrayColumn, String refName, boolean positive, Table dataHierTable) {
        return this.getArrayOpSql(arrayColumn, refName, positive, dataHierTable, "LIKE");
    }

    @Override
    public String getArrayIlikeSql(Column arrayColumn, String refName, boolean positive, Table dataHierTable) {
        return this.getArrayOpSql(arrayColumn, refName, positive, dataHierTable, "ILIKE");
    }

    protected String getArrayOpSql(Column arrayColumn, String refName, boolean positive, Table dataHierTable, String op) {
        Table table = arrayColumn.getTable();
        String tableAliasName = this.openQuote() + this.getTableName(refName) + this.closeQuote();
        String sql = String.format("EXISTS (SELECT 1 FROM %s AS %s WHERE %s = %s AND %s %s ?)", this.getArraySubQuery(arrayColumn, tableAliasName).toSql(), tableAliasName, dataHierTable.getColumn("id").getFullQuotedName(), tableAliasName + '.' + table.getColumn("id").getQuotedName(), tableAliasName + '.' + "item", op);
        if (!positive) {
            sql = "NOT(" + sql + ")";
        }
        return sql;
    }

    @Override
    public Array createArrayOf(int type, Object[] elements, Connection connection) throws SQLException {
        String typeName;
        if (elements == null || elements.length == 0) {
            return null;
        }
        block0 : switch (type) {
            case 12: {
                typeName = "varchar";
                break;
            }
            case 2005: {
                typeName = "text";
                break;
            }
            case -7: {
                typeName = "bool";
                break;
            }
            case -5: {
                typeName = "int8";
                break;
            }
            case 8: {
                typeName = "float8";
                break;
            }
            case 93: {
                typeName = "timestamp";
                break;
            }
            case 5: {
                typeName = "int2";
                break;
            }
            case 4: {
                typeName = "int4";
                break;
            }
            case 1111: {
                switch (this.idType) {
                    case VARCHAR: {
                        typeName = "varchar";
                        break block0;
                    }
                    case UUID: {
                        typeName = "uuid";
                        break block0;
                    }
                    case SEQUENCE: {
                        typeName = "int8";
                        break block0;
                    }
                }
                throw new AssertionError((Object)("Unknown id type: " + (Object)((Object)this.idType)));
            }
            default: {
                throw new AssertionError((Object)("Unknown type: " + type));
            }
        }
        return connection.createArrayOf(typeName, elements);
    }

    @Override
    public String getSQLStatementsFilename() {
        return "nuxeovcs/postgresql.sql.txt";
    }

    @Override
    public String getTestSQLStatementsFilename() {
        return "nuxeovcs/postgresql.test.sql.txt";
    }

    @Override
    public Map<String, Serializable> getSQLStatementsProperties(Model model, Database database) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        switch (this.idType) {
            case VARCHAR: {
                properties.put("idType", (Serializable)((Object)"varchar(36)"));
                properties.put("idTypeParam", (Serializable)((Object)"varchar"));
                properties.put("idNotPresent", (Serializable)((Object)"'-'"));
                properties.put("sequenceEnabled", Boolean.FALSE);
                break;
            }
            case UUID: {
                properties.put("idType", (Serializable)((Object)"uuid"));
                properties.put("idTypeParam", (Serializable)((Object)"uuid"));
                properties.put("idNotPresent", (Serializable)((Object)"'00000000-FFFF-FFFF-FFFF-FFFF00000000'"));
                properties.put("sequenceEnabled", Boolean.FALSE);
                break;
            }
            case SEQUENCE: {
                properties.put("idType", (Serializable)((Object)"int8"));
                properties.put("idTypeParam", (Serializable)((Object)"int8"));
                properties.put("idNotPresent", (Serializable)((Object)"-1"));
                properties.put("sequenceEnabled", Boolean.TRUE);
                properties.put("idSequenceName", (Serializable)((Object)this.idSequenceName));
            }
        }
        properties.put("aclOptimizationsEnabled", Boolean.valueOf(this.aclOptimizationsEnabled));
        properties.put("pathOptimizationsEnabled", Boolean.valueOf(this.pathOptimizationsEnabled));
        properties.put("fulltextAnalyzer", (Serializable)((Object)this.fulltextAnalyzer));
        properties.put("fulltextEnabled", Boolean.valueOf(!this.fulltextDisabled));
        properties.put("clusteringEnabled", Boolean.valueOf(this.clusteringEnabled));
        properties.put("proxiesEnabled", Boolean.valueOf(this.proxiesEnabled));
        properties.put("softDeleteEnabled", Boolean.valueOf(this.softDeleteEnabled));
        if (!this.fulltextDisabled) {
            Table ft = database.getTable("fulltext");
            properties.put("fulltextTable", (Serializable)((Object)ft.getQuotedName()));
            FulltextConfiguration fti = model.getFulltextConfiguration();
            ArrayList<String> lines = new ArrayList<String>(fti.indexNames.size());
            for (String indexName : fti.indexNames) {
                String suffix = model.getFulltextIndexSuffix(indexName);
                Column ftft = ft.getColumn("fulltext" + suffix);
                Column ftst = ft.getColumn("simpletext" + suffix);
                Column ftbt = ft.getColumn("binarytext" + suffix);
                String concat = this.compatibilityFulltextTable ? "  NEW.%s := COALESCE(NEW.%s, ''::TSVECTOR) || COALESCE(NEW.%s, ''::TSVECTOR);" : "  NEW.%s := ' ' || COALESCE(NEW.%s, '') || ' ' || COALESCE(NEW.%s, '') || ' ';";
                String line = String.format(concat, ftft.getQuotedName(), ftst.getQuotedName(), ftbt.getQuotedName());
                lines.add(line);
            }
            properties.put("fulltextTriggerStatements", (Serializable)((Object)StringUtils.join(lines, (String)"\n")));
        }
        String[] permissions = NXCore.getSecurityService().getPermissionsToCheck("Browse");
        LinkedList<String> permsList = new LinkedList<String>();
        for (String perm : permissions) {
            permsList.add("('" + perm + "')");
        }
        properties.put("readPermissions", (Serializable)((Object)StringUtils.join(permsList, (String)", ")));
        properties.put("usersSeparator", (Serializable)((Object)this.getUsersSeparator()));
        properties.put("everyone", (Serializable)((Object)"Everyone"));
        properties.put("readAclMaxSize", (Serializable)((Object)Integer.toString(this.readAclMaxSize)));
        properties.put("unlogged", (Serializable)((Object)this.unloggedKeyword));
        return properties;
    }

    @Override
    public boolean preCreateTable(Connection connection, Table table, Model model, Database database) throws SQLException {
        String tableKey = table.getKey();
        if ("hierarchy".equals(tableKey)) {
            this.hierarchyCreated = true;
            return true;
        }
        if ("ancestors".equals(tableKey)) {
            if (this.hierarchyCreated) {
                return true;
            }
            String sql = "SELECT COUNT(*) FROM hierarchy WHERE NOT isproperty";
            Statement s = connection.createStatement();
            ResultSet rs = s.executeQuery(sql);
            rs.next();
            long count = rs.getLong(1);
            rs.close();
            s.close();
            if (count > 100000L) {
                this.pathOptimizationsEnabled = false;
                log.error((Object)"Table ANCESTORS not initialized automatically because table HIERARCHY is too big. Upgrade by hand by calling: SELECT nx_init_ancestors()");
            }
            return true;
        }
        return true;
    }

    @Override
    public List<String> getPostCreateTableSqls(Table table, Model model, Database database) {
        if ("ancestors".equals(table.getKey())) {
            ArrayList<String> sqls = new ArrayList<String>();
            if (this.pathOptimizationsEnabled) {
                sqls.add("SELECT nx_init_ancestors()");
            } else {
                log.info((Object)"Path optimizations disabled");
            }
            return sqls;
        }
        return Collections.emptyList();
    }

    @Override
    public void existingTableDetected(Connection connection, Table table, Model model, Database database) throws SQLException {
        if ("ancestors".equals(table.getKey())) {
            if (!this.pathOptimizationsEnabled) {
                log.info((Object)"Path optimizations disabled");
                return;
            }
            String sql = "SELECT id FROM ancestors LIMIT 1";
            Statement s = connection.createStatement();
            ResultSet rs = s.executeQuery(sql);
            boolean empty = !rs.next();
            rs.close();
            s.close();
            if (empty) {
                this.pathOptimizationsEnabled = false;
                log.error((Object)"Table ANCESTORS empty, must be upgraded by hand by calling: SELECT nx_init_ancestors()");
                log.info((Object)"Path optimizations disabled");
            }
        }
    }

    @Override
    public boolean isClusteringSupported() {
        return true;
    }

    @Override
    public String getClusterInsertInvalidations() {
        return "SELECT NX_CLUSTER_INVAL(?, ?, ?)";
    }

    @Override
    public String getClusterGetInvalidations() {
        return "DELETE FROM cluster_invals WHERE nodeid = pg_backend_pid() RETURNING id, fragments, kind";
    }

    @Override
    public boolean isConnectionClosedException(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof SocketException) {
            return true;
        }
        String message = t.getMessage();
        if (message != null && message.contains("FATAL:")) {
            return true;
        }
        return t instanceof SQLException && "08003".equals(((SQLException)t).getSQLState());
    }

    @Override
    public boolean isConcurrentUpdateException(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof SQLException) {
            String sqlState = ((SQLException)t).getSQLState();
            if ("23503".equals(sqlState)) {
                return true;
            }
            if ("23505".equals(sqlState)) {
                return true;
            }
            if ("40P01".equals(sqlState)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsPaging() {
        return true;
    }

    @Override
    public String addPagingClause(String sql, long limit, long offset) {
        return sql + String.format(" LIMIT %d OFFSET %d", limit, offset);
    }

    @Override
    public boolean supportsWith() {
        return false;
    }

    @Override
    public void performAdditionalStatements(Connection connection) throws SQLException {
        HashSet<String> dbPermissions = new HashSet<String>();
        String sql = "SELECT * FROM aclr_permission";
        Statement s = connection.createStatement();
        ResultSet rs = s.executeQuery(sql);
        while (rs.next()) {
            dbPermissions.add(rs.getString(1));
        }
        rs.close();
        s.close();
        HashSet<String> confPermissions = new HashSet<String>();
        SecurityService securityService = NXCore.getSecurityService();
        for (String perm : securityService.getPermissionsToCheck("Browse")) {
            confPermissions.add(perm);
        }
        if (!dbPermissions.equals(confPermissions)) {
            log.error((Object)"Security permission for BROWSE has changed, you need to rebuild the optimized read acls:DROP TABLE aclr_permission; DROP TABLE aclr; then restart.");
        }
    }

    public String getUsersSeparator() {
        if (this.usersSeparator == null) {
            return DEFAULT_USERS_SEPARATOR;
        }
        return this.usersSeparator;
    }

    @Override
    public String getValidationQuery() {
        return "";
    }

    @Override
    public String getAncestorsIdsSql() {
        return "SELECT NX_ANCESTORS(?)";
    }

    @Override
    public boolean needsNullsLastOnDescSort() {
        return true;
    }

    @Override
    public String getDateCast() {
        return "DATE(%s)";
    }

    @Override
    public String castIdToVarchar(String expr) {
        switch (this.idType) {
            case VARCHAR: {
                return expr;
            }
            case UUID: {
                return expr + "::varchar";
            }
            case SEQUENCE: {
                return expr + "::varchar";
            }
        }
        throw new AssertionError((Object)("Unknown id type: " + (Object)((Object)this.idType)));
    }

    @Override
    public Dialect.DialectIdType getIdType() {
        return this.idType;
    }

    @Override
    public String getSoftDeleteSql() {
        return "SELECT NX_DELETE(?, ?)";
    }

    @Override
    public String getSoftDeleteCleanupSql() {
        return "SELECT NX_DELETE_PURGE(?, ?)";
    }

    @Override
    public String getBinaryFulltextSql(List<String> columns) {
        if (this.compatibilityFulltextTable) {
            ArrayList<String> columnsAs = new ArrayList<String>(columns.size());
            for (String col : columns) {
                columnsAs.add("regexp_replace(" + col + "::text, $$'|'\\:[^']*'?$$, ' ', 'g')");
            }
            return "SELECT " + StringUtils.join(columnsAs, (String)", ") + " FROM fulltext WHERE id=?";
        }
        return super.getBinaryFulltextSql(columns);
    }

    public static class ArraySubQueryPostgreSQL
    extends Dialect.ArraySubQuery {
        protected Dialect dialect = null;
        protected Table fakeSubqueryTableAlias = null;

        public ArraySubQueryPostgreSQL(Column arrayColumn, String alias) {
            super(arrayColumn, alias);
            this.dialect = arrayColumn.getTable().getDialect();
            this.fakeSubqueryTableAlias = new TableAlias(arrayColumn.getTable(), alias);
        }

        @Override
        public Column getSubQueryIdColumn() {
            Column column = this.fakeSubqueryTableAlias.getColumn("id");
            return new ArraySubQueryPostgreSQLColumn(column.getPhysicalName(), column.getType());
        }

        @Override
        public Column getSubQueryValueColumn() {
            return new ArraySubQueryPostgreSQLColumn("item", this.arrayColumn.getBaseType());
        }

        @Override
        public String toSql() {
            Table table = this.arrayColumn.getTable();
            return String.format("(SELECT %s, UNNEST(%s) AS %s, generate_subscripts(%s, 1) AS %s FROM %s) ", table.getColumn("id").getQuotedName(), this.arrayColumn.getQuotedName(), "item", this.arrayColumn.getQuotedName(), "pos", table.getRealTable().getQuotedName());
        }

        public class ArraySubQueryPostgreSQLColumn
        extends Column {
            private static final long serialVersionUID = 1L;

            ArraySubQueryPostgreSQLColumn(String columnName, ColumnType columnType) {
                super(ArraySubQueryPostgreSQL.this.fakeSubqueryTableAlias, columnName, columnType, columnName);
            }

            @Override
            public String getFullQuotedName() {
                return this.dialect.openQuote() + ArraySubQueryPostgreSQL.this.subQueryAlias + this.dialect.closeQuote() + '.' + this.getQuotedName();
            }
        }
    }
}

