/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jboss.el.ExpressionFactoryImpl;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.el.ExpressionContext;

@Operation(id="Actions.GET", category="Services", label="List available actions", description="Retrieve list of available actions for a given category. Action context is built based on the Operation context (currentDocument will be fetched from Context if not provided as input). If this operation is executed in a chain that initialized the Seam context, it will be used for Action context", addToStudio=false)
public class GetActions {
    private static final String SEAM_ACTION_CONTEXT = "seamActionContext";
    public static final String ID = "Actions.GET";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService automation;
    @Context
    protected ActionManager actionService;
    @Param(name="category", required=true)
    protected String category;
    @Param(name="lang", required=false)
    protected String lang;

    protected DocumentModel getCurrentDocumentFromContext() throws OperationException {
        String cdRef = (String)this.ctx.get((Object)"currentDocument");
        return (DocumentModel)this.automation.getAdaptedValue(this.ctx, (Object)cdRef, DocumentModel.class);
    }

    protected ActionContext getActionContext(DocumentModel currentDocument) throws OperationException {
        if (this.ctx.containsKey((Object)SEAM_ACTION_CONTEXT)) {
            return (ActionContext)this.ctx.get((Object)SEAM_ACTION_CONTEXT);
        }
        ELActionContext actionContext = new ELActionContext((ELContext)new ExpressionContext(), (ExpressionFactory)new ExpressionFactoryImpl());
        actionContext.setDocumentManager(this.session);
        actionContext.setCurrentPrincipal((NuxeoPrincipal)this.session.getPrincipal());
        if (currentDocument != null) {
            actionContext.setCurrentDocument(currentDocument);
        } else {
            actionContext.setCurrentDocument(this.getCurrentDocumentFromContext());
        }
        actionContext.putAllLocalVariables((Map)this.ctx);
        return actionContext;
    }

    protected Locale getLocale() {
        if (this.lang == null) {
            this.lang = (String)this.ctx.get((Object)"lang");
        }
        if (this.lang == null) {
            this.lang = "en";
        }
        return new Locale(this.lang);
    }

    protected String translate(String key) {
        if (key == null) {
            return "";
        }
        return I18NUtils.getMessageString((String)"messages", (String)key, (Object[])new Object[0], (Locale)this.getLocale());
    }

    @OperationMethod
    public Blob run() throws OperationException {
        return this.run(null);
    }

    @OperationMethod
    public Blob run(DocumentModel currentDocument) throws OperationException {
        ActionContext actionContext = this.getActionContext(currentDocument);
        List actions = this.actionService.getActions(this.category, actionContext);
        JSONArray rows = new JSONArray();
        for (Action action : actions) {
            JSONObject obj = new JSONObject();
            obj.element("id", (Object)action.getId());
            obj.element("link", (Object)action.getLink());
            obj.element("icon", (Object)action.getIcon());
            String label = this.translate(action.getLabel());
            obj.element("label", (Object)label);
            String help = this.translate(action.getHelp());
            obj.element("help", (Object)help);
            JSONObject properties = new JSONObject();
            Map actionProperties = action.getProperties();
            for (Map.Entry entry : actionProperties.entrySet()) {
                properties.element((String)entry.getKey(), entry.getValue());
            }
            obj.element("properties", (Map)properties);
            rows.add((Object)obj);
        }
        try {
            return new ByteArrayBlob(rows.toString().getBytes("UTF-8"), "application/json");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

