/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;

@Operation(id="Relations.GetRelations", category="Services", label="Get Linked Documents", description="Get the relations for the input document. The 'outgoing' parameter ca be used to specify whether outgoing or incoming relations should be returned. Retuns a document list.")
public class GetRelations {
    public static final String ID = "Relations.GetRelations";
    @Context
    protected CoreSession session;
    @Context
    protected RelationManager relations;
    @Param(name="predicate")
    protected String predicate;
    @Param(name="outgoing", required=false)
    protected boolean outgoing = true;
    @Param(name="graphName", required=false)
    protected String graphName;

    @OperationMethod
    public DocumentModelList run(DocumentModel doc) {
        QNameResource res = this.getDocumentResource(doc);
        Resource predicate = this.getPredicate();
        return this.getDocuments(res, predicate);
    }

    protected QNameResource getDocumentResource(DocumentModel document) throws ClientException {
        return (QNameResource)this.relations.getResource("http://www.nuxeo.org/document/uid/", (Serializable)document, null);
    }

    protected Resource getPredicate() {
        return this.predicate != null && this.predicate.length() > 0 ? new ResourceImpl(this.predicate) : null;
    }

    protected DocumentModelList getDocuments(QNameResource res, Resource predicate) throws ClientException {
        if (this.outgoing) {
            List<Statement> statements = this.getOutgoingStatements(res, predicate);
            DocumentModelListImpl docs = new DocumentModelListImpl(statements.size());
            for (Statement st : statements) {
                DocumentModel dm = this.getDocumentModel(st.getObject());
                if (dm == null) continue;
                docs.add((Object)dm);
            }
            return docs;
        }
        List<Statement> statements = this.getIncomingStatements(res, predicate);
        DocumentModelListImpl docs = new DocumentModelListImpl(statements.size());
        for (Statement st : statements) {
            DocumentModel dm = this.getDocumentModel((Node)st.getSubject());
            if (dm == null) continue;
            docs.add((Object)dm);
        }
        return docs;
    }

    protected List<Statement> getIncomingStatements(QNameResource res, Resource predicate) throws ClientException {
        return this.relations.getGraphByName(this.getGraphName()).getStatements(null, (Node)predicate, (Node)res);
    }

    protected List<Statement> getOutgoingStatements(QNameResource res, Resource predicate) throws ClientException {
        return this.relations.getGraphByName(this.getGraphName()).getStatements((Node)res, (Node)predicate, null);
    }

    protected DocumentModel getDocumentModel(Node node) throws ClientException {
        if (node.isQNameResource()) {
            QNameResource resource = (QNameResource)node;
            Map<String, CoreSession> context = Collections.singletonMap("CoreSession", this.session);
            Serializable o = this.relations.getResourceRepresentation(resource.getNamespace(), (Resource)resource, context);
            if (o instanceof DocumentModel) {
                return (DocumentModel)o;
            }
        }
        return null;
    }

    public String getGraphName() {
        if (StringUtils.isEmpty((String)this.graphName)) {
            return "default";
        }
        return this.graphName;
    }
}

