/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.users;

import java.util.Set;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.automation.features.PrincipalHelper;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="Document.GetUsersAndGroups", category="Users & Groups", label="Get Users and Groups", description="Fetch the users and groups that have a given permission on the input document and then set them in the context under the given key variable name. The operation returns the input document. You can later use the list of identifiers set by this operation on the context from another operation. The 'key' argument represents the variable name and the 'permission' argument the permission to check. If the 'ignore groups' argument is false then groups will be part of the result. If the 'resolve groups' argument is true then groups are recursively resolved, adding user members of these groups in place of them. Be <b>warned</b> that this may be a very consuming operation. If the 'prefix identifiers' argument is true, then user identifiers are prefixed by 'user:' and groups identifiers are prefixed by 'group:'.")
public class GetDocumentUsersAndGroups {
    public static final String ID = "Document.GetUsersAndGroups";
    @Context
    protected PermissionProvider permissionProvider;
    @Context
    protected UserManager umgr;
    @Context
    protected OperationContext ctx;
    @Param(name="permission")
    protected String permission;
    @Param(name="variable name")
    protected String key;
    @Param(name="ignore groups", required=false, values={"false"})
    protected boolean ignoreGroups = false;
    @Param(name="resolve groups", required=false, values={"false"})
    protected boolean resolveGroups = false;
    @Param(name="prefix identifiers", required=false, values={"false"})
    protected boolean prefixIds = false;

    @OperationMethod
    public DocumentModel run(DocumentModel input) {
        PrincipalHelper ph = new PrincipalHelper(this.umgr, this.permissionProvider);
        Set<String> result = ph.getUserAndGroupIdsForPermission(input, this.permission, this.ignoreGroups, this.resolveGroups, this.prefixIds);
        this.ctx.put(this.key, (Object)new StringList(result));
        return input;
    }
}

