/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import org.javasimon.Callback;
import org.javasimon.CallbackSkeleton;
import org.javasimon.Counter;
import org.javasimon.Manager;
import org.javasimon.ManagerConfiguration;
import org.javasimon.Simon;
import org.javasimon.Stopwatch;
import org.javasimon.SwitchingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimonManager {
    public static final String PROPERTY_CONFIG_FILE_NAME = "javasimon.config.file";
    public static final String PROPERTY_CONFIG_RESOURCE_NAME = "javasimon.config.resource";
    private static Manager manager = new SwitchingManager();

    public static void init() {
        CallbackSkeleton tempraryCallback = new CallbackSkeleton();
        manager.callback().addCallback(tempraryCallback);
        try {
            String resourceName;
            manager.configuration().clear();
            String fileName = System.getProperty(PROPERTY_CONFIG_FILE_NAME);
            if (fileName != null) {
                manager.configuration().readConfig(new FileReader(fileName));
            }
            if ((resourceName = System.getProperty(PROPERTY_CONFIG_RESOURCE_NAME)) != null) {
                InputStream is = SimonManager.class.getClassLoader().getResourceAsStream(resourceName);
                if (is == null) {
                    throw new FileNotFoundException(resourceName);
                }
                manager.configuration().readConfig(new InputStreamReader(is));
            }
        }
        catch (Exception e) {
            manager.callback().warning("SimonManager initialization error", e);
        }
        manager.callback().removeCallback(tempraryCallback);
    }

    private SimonManager() {
        throw new UnsupportedOperationException();
    }

    public static Simon getSimon(String name) {
        return manager.getSimon(name);
    }

    public static void destroySimon(String name) {
        manager.destroySimon(name);
    }

    public static Counter getCounter(String name) {
        return manager.getCounter(name);
    }

    public static Stopwatch getStopwatch(String name) {
        return manager.getStopwatch(name);
    }

    public static void enable() {
        manager.enable();
    }

    public static void disable() {
        manager.disable();
    }

    public static boolean isEnabled() {
        return manager.isEnabled();
    }

    public static Simon getRootSimon() {
        return manager.getRootSimon();
    }

    public static Collection<String> simonNames() {
        return manager.simonNames();
    }

    public static void clear() {
        manager.clear();
    }

    public static Callback callback() {
        return manager.callback();
    }

    public static ManagerConfiguration configuration() {
        return manager.configuration();
    }

    public static Manager manager() {
        return manager;
    }

    static {
        SimonManager.init();
    }
}

