/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.directory.localconfiguration.DirectoryConfiguration;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.UserMultiTenantManagement;
import org.nuxeo.runtime.api.Framework;

public class DefaultUserMultiTenantManagement
implements UserMultiTenantManagement {
    protected static final Log log = LogFactory.getLog(DefaultUserMultiTenantManagement.class);
    protected static final String SUFFIX_SEPARATOR = "-";

    protected String getDirectorySuffix(DocumentModel documentContext) {
        LocalConfigurationService localConfigurationService = (LocalConfigurationService)Framework.getService(LocalConfigurationService.class);
        DirectoryConfiguration configuration = (DirectoryConfiguration)localConfigurationService.getConfiguration(DirectoryConfiguration.class, "DirectoryLocalConfiguration", documentContext);
        if (configuration != null && configuration.getDirectorySuffix() != null) {
            return SUFFIX_SEPARATOR + configuration.getDirectorySuffix();
        }
        return null;
    }

    @Override
    public void queryTransformer(UserManager um, Map<String, Serializable> filter, Set<String> fulltext, DocumentModel context) throws ClientException {
        String groupId = um.getGroupIdField();
        if (filter == null || fulltext == null) {
            throw new ClientException("Filter and Fulltext must be not null, please check");
        }
        if (this.getDirectorySuffix(context) == null) {
            log.debug((Object)"Directory Local Configuration is null, don't need to filter");
            return;
        }
        String groupIdSuffix = this.getDirectorySuffix(context);
        if (!filter.containsKey(groupId)) {
            log.debug((Object)("no filter on group id, need to filter with the directory local configuration suffix : " + groupId + " = %" + groupIdSuffix));
            filter.put(groupId, (Serializable)((Object)("%" + groupIdSuffix)));
            fulltext.add(groupId);
            return;
        }
        if (!(filter.get(groupId) instanceof String)) {
            throw new UnsupportedOperationException("Filter value on group id is not a string : " + filter.get(groupId));
        }
        String filterIdValue = (String)((Object)filter.get(um.getGroupIdField()));
        filter.put(groupId, (Serializable)((Object)(filterIdValue + groupIdSuffix)));
    }

    @Override
    public DocumentModel groupTransformer(UserManager um, DocumentModel group, DocumentModel context) throws ClientException {
        if (context == null) {
            return group;
        }
        String groupIdValue = group.getPropertyValue(um.getGroupIdField()) + this.getDirectorySuffix(context);
        group.setPropertyValue(um.getGroupIdField(), (Serializable)((Object)groupIdValue));
        return group;
    }

    @Override
    public String groupnameTranformer(UserManager um, String groupname, DocumentModel context) {
        String suffix = this.getDirectorySuffix(context);
        if (suffix != null) {
            groupname = groupname + suffix;
        }
        return groupname;
    }
}

