/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.local.LocalSession;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class RepositoryService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.core.repository.RepositoryService");
    private static final Log log = LogFactory.getLog(RepositoryService.class);
    public static final String XP_REPOSITORY = "repository";
    private final Map<String, org.nuxeo.ecm.core.model.Repository> repositories = new HashMap<String, org.nuxeo.ecm.core.model.Repository>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        log.info((Object)"Shutting down repository manager");
        Map<String, org.nuxeo.ecm.core.model.Repository> map = this.repositories;
        synchronized (map) {
            for (org.nuxeo.ecm.core.model.Repository repository : this.repositories.values()) {
                repository.shutdown();
            }
            this.repositories.clear();
        }
    }

    public int getApplicationStartedOrder() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationStarted(ComponentContext context) {
        Framework.addListener((RuntimeServiceListener)new RuntimeServiceListener(){

            public void handleEvent(RuntimeServiceEvent event) {
                if (event.id != 2) {
                    return;
                }
                Framework.removeListener((RuntimeServiceListener)this);
                RepositoryService.this.shutdown();
            }
        });
        RepositoryInitializationHandler handler = RepositoryInitializationHandler.getInstance();
        if (handler == null) {
            return;
        }
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        boolean started = false;
        boolean ok = false;
        Transaction tx = TransactionHelper.suspendTransaction();
        try {
            for (String name : repositoryManager.getRepositoryNames()) {
                this.openRepository(name);
            }
        }
        finally {
            TransactionHelper.resumeTransaction((Transaction)tx);
        }
        try {
            started = !TransactionHelper.isTransactionActive() && TransactionHelper.startTransaction();
            for (String name : repositoryManager.getRepositoryNames()) {
                this.initializeRepository(handler, name);
            }
            ok = true;
        }
        finally {
            if (started) {
                try {
                    if (!ok) {
                        TransactionHelper.setTransactionRollbackOnly();
                    }
                }
                finally {
                    TransactionHelper.commitOrRollbackTransaction();
                }
            }
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return (T)((Object)this);
        }
        if (adapter.isAssignableFrom(CoreSession.class)) {
            return (T)LocalSession.createInstance();
        }
        return null;
    }

    protected void openRepository(String name) throws ClientException {
        new UnrestrictedSessionRunner(name){

            public void run() throws ClientException {
            }
        }.runUnrestricted();
    }

    protected void initializeRepository(final RepositoryInitializationHandler handler, String name) {
        try {
            new UnrestrictedSessionRunner(name){

                public void run() throws ClientException {
                    handler.initializeRepository(this.session);
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new RuntimeException("Failed to initialize repository '" + name + "': " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.nuxeo.ecm.core.model.Repository getRepository(String repositoryName) {
        Map<String, org.nuxeo.ecm.core.model.Repository> map = this.repositories;
        synchronized (map) {
            org.nuxeo.ecm.core.model.Repository repository = this.repositories.get(repositoryName);
            if (repository == null) {
                RepositoryFactory factory = this.getFactory(repositoryName);
                if (factory == null) {
                    return null;
                }
                repository = (org.nuxeo.ecm.core.model.Repository)factory.call();
                this.repositories.put(repositoryName, repository);
            }
            return repository;
        }
    }

    protected RepositoryFactory getFactory(String repositoryName) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        if (repositoryManager == null) {
            return null;
        }
        Repository repo = repositoryManager.getRepository(repositoryName);
        if (repo == null) {
            return null;
        }
        RepositoryFactory repositoryFactory = (RepositoryFactory)repo.getRepositoryFactory();
        if (repositoryFactory == null) {
            throw new NullPointerException("Missing repositoryFactory for repository: " + repositoryName);
        }
        return repositoryFactory;
    }

    public List<String> getRepositoryNames() {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        return repositoryManager.getRepositoryNames();
    }
}

